<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$operator = $_SESSION['username'];

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

/** 1) AMBIL TRANSAKSI BELUM LUNAS
 *   - Anggap belum lunas = Lunas NULL atau 0
 */
$sql = "
  SELECT no_trans, No_pasien, No_obat, No_dokter, Tanggal_beli, Jumlah_beli, IFNULL(Total_harga,0) AS Total_harga
  FROM transaksi
  WHERE IFNULL(Lunas,0) = 0
";
$result = $conn->query($sql);
if (!$result) {
    die("Query SELECT gagal: " . htmlspecialchars($conn->error));
}

$tot_jenderal = 0;
$transaksi_data = [];
while ($row = $result->fetch_assoc()) {
    $transaksi_data[] = $row;
    $tot_jenderal += (float)$row['Total_harga'];
}

if (empty($transaksi_data)) {
    echo "<center><font face='verdana' size='5' color='red'>Tidak ada transaksi belum lunas.</font><br>
    <div style='font-family:verdana'>
      Tips: Cek di phpMyAdmin apakah ada baris dengan Lunas = 0 atau NULL.<br>
      Contoh cek cepat:<br>
      <code>SELECT COUNT(*) FROM transaksi WHERE IFNULL(Lunas,0) = 0;</code>
    </div></center>";
    exit;
}

/** 2) AMBIL no_id OPERATOR (jika perlu tulis ke No_op bila kolomnya ada) */
$no_op = null;
$stmt = $conn->prepare("SELECT no_id FROM operator WHERE username = ?");
$stmt->bind_param("s", $operator);
$stmt->execute();
$stmt->bind_result($no_op);
$stmt->fetch();
$stmt->close();

/** 3) CEK apakah kolom No_op ada di tabel transaksi */
$hasNoOp = false;
$chk = $conn->query("SHOW COLUMNS FROM transaksi LIKE 'No_op'");
if ($chk && $chk->num_rows > 0) {
    $hasNoOp = true;
}
if ($chk) $chk->close();

/** 4) UPDATE jadi LUNAS */
if ($hasNoOp && !empty($no_op)) {
    $upd = $conn->prepare("UPDATE transaksi SET Lunas = 1, No_op = ? WHERE IFNULL(Lunas,0) = 0");
    $upd->bind_param("i", $no_op);
    $upd->execute();
    $upd->close();
} else {
    // fallback: hanya set Lunas = 1
    $conn->query("UPDATE transaksi SET Lunas = 1 WHERE IFNULL(Lunas,0) = 0");
}

$tanggal_cetak = date("d/m/Y H:i:s");

$stmt = $conn->prepare("SELECT Nama_apotek FROM logo LIMIT 1");
$stmt->execute();
$stmt->bind_result($jeneng_apt);
$stmt->fetch();
$stmt->close();


/** 5) CETAK KWITANSI */
echo "<center>
<font face='verdana' size='6'><b>KWITANSI PEMBAYARAN</b></font><br>
<font face='verdana' size='3'>" . htmlspecialchars($jeneng_apt) . "</font><br>
<font face='verdana' size='2'>
Operator: <b>" . htmlspecialchars($operator) . "</b> | Waktu Cetak: $tanggal_cetak
</font>
</center><br><br>";

echo "<table border='1' cellspacing='0' cellpadding='8' width='95%' align='center' style='font-family:verdana; font-size:13px; border-collapse:collapse;'>
<tr bgcolor='#cccccc'>
  <th>No. Transaksi</th>
  <th>Nama Pasien</th>
  <th>Nama Obat</th>
  <th>Nama Dokter</th>
  <th>Tanggal Beli</th>
  <th>Jumlah Beli</th>
  <th>Total Harga</th>
</tr>";

foreach ($transaksi_data as $row) {
    echo "<tr>
        <td align='center'>" . htmlspecialchars($row['no_trans']) . "</td>
        <td align='center'>" . htmlspecialchars($_SESSION['nama_pasien']) . "</td>
        <td align='center'>" . htmlspecialchars($_SESSION['nama_obat']) . "</td>
        <td align='center'>" . htmlspecialchars($_SESSION['nama_dokter']) . "</td>
        <td align='center'>" . htmlspecialchars($row['Tanggal_beli']) . "</td>
        <td align='right'>" . htmlspecialchars($row['Jumlah_beli']) . "</td>
        <td align='right'>Rp. " . number_format($row['Total_harga'], 0, ',', '.') . "</td>
    </tr>";
}

echo "<tr bgcolor='#e0e0e0'>
  <td colspan='6' align='right'><b>GRAND TOTAL</b></td>
  <td align='right'><b>Rp. " . number_format($tot_jenderal, 0, ',', '.') . "</b></td>
</tr>
</table>";

echo "<br><br><center>
<font face='verdana' size='3'>Terima kasih atas kepercayaan Anda.</font><br>
<font face='verdana' size='3'><b>Semua transaksi di atas telah dinyatakan LUNAS.</b></font>
<br><br>
<button onclick='window.print()' style='font-family:verdana; font-size:15px; padding:10px 20px;'>🖨️ Cetak Kwitansi</button>
</center>";

$conn->close();
