<?php
session_start();

// Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

include 'db.php';
$pesan = "";
$data_obat = null;

// Tahap 1: jika user menekan tombol CARI
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['cari'])) {
    $obat = trim($_POST['obat'] ?? '');

    if ($obat === '') {
        $pesan = "<p style='color:red; font-family:verdana;'>⚠️ Nama obat harus diisi!</p>";
    } else {
        $conn = new mysqli($servername, $username, $password, $database);
        if ($conn->connect_error) {
            die("Koneksi gagal: " . $conn->connect_error);
        }

        // ✅ Perbaikan: pencarian lebih fleksibel (tidak case sensitive & bisa sebagian)
        $like = "%" . $obat . "%";
        $stmt = $conn->prepare("
            SELECT Nama_obat, Kodebar, Kategori, Harga_asli_obat, Harga_jual_obat, Stok, Dosis, Keterangan, Gbr_obat
            FROM obat
            WHERE LOWER(Nama_obat) LIKE LOWER(?)
            LIMIT 1
        ");
        $stmt->bind_param("s", $like);
        $stmt->execute();
        $hasil = $stmt->get_result();

        if ($hasil->num_rows > 0) {
            $data_obat = $hasil->fetch_assoc();
        } else {
            $pesan = "<p style='color:red; font-family:verdana;'>❌ Data obat tidak ditemukan!</p>";
        }

        $stmt->close();
        $conn->close();
    }
}

// Tahap 2: jika user menekan tombol HAPUS
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['hapus'])) {
    $obat_hapus = trim($_POST['nama_obat_hapus'] ?? '');

    if ($obat_hapus !== '') {
        $conn = new mysqli($servername, $username, $password, $database);
        if ($conn->connect_error) {
            die("Koneksi gagal: " . $conn->connect_error);
        }

        $stmt = $conn->prepare("DELETE FROM obat WHERE Nama_obat = ?");
        $stmt->bind_param("s", $obat_hapus);
        $stmt->execute();

        if ($stmt->affected_rows > 0) {
            $pesan = "<p style='color:green; font-family:verdana;'>✅ Data obat <b>" . htmlspecialchars($obat_hapus) . "</b> berhasil dihapus!</p>";
        } else {
            $pesan = "<p style='color:red; font-family:verdana;'>⚠️ Gagal menghapus data obat.</p>";
        }

        $stmt->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Hapus Data Obat</title>
</head>
<body>
<center>
    <font face="verdana" size="6">💊 Hapus Data Obat</font><br><br>

    <?= $pesan ?>

    <!-- Form pencarian -->
    <form method="post">
        <font face="verdana" size="4">Masukkan nama obat (cukup sebagian kata):</font><br>
        <input type="text" name="obat" size="50" required>
        <br><br>
        <input type="submit" name="cari" value="Cari" style="font-size:18px;">
        <br><br>
        <a href="dashboard.php"><font face="verdana" size="4">⬅️ Kembali</font></a>
    </form>

    <br>

    <?php if ($data_obat): ?>
        <hr width="80%">
        <font face="verdana" size="4">Hasil pencarian:</font><br><br>
        <table border="1" cellpadding="8" cellspacing="0" style="border-collapse:collapse; font-family:verdana;">
            <tr bgcolor="#f2f2f2">
                <th>Nama Obat</th>
		        <th>Barcode</th>
                <th>Kategori</th>
                <th>Harga Asli</th>
                <th>Harga Jual</th>
                <th>Stok</th>
                <th>Dosis</th>
                <th>Keterangan</th>
                <th>Gambar</th>
                <th>Aksi</th>
            </tr>
            <tr>
                <td><?= htmlspecialchars($data_obat['Nama_obat']) ?></td>
		        <td><?= htmlspecialchars($data_obat['Kodebar']) ?></td>
                <td><?= htmlspecialchars($data_obat['Kategori']) ?></td>
                <td><?= number_format($data_obat['Harga_asli_obat'], 0, ',', '.') ?></td>
                <td><?= number_format($data_obat['Harga_jual_obat'], 0, ',', '.') ?></td>
                <td><?= htmlspecialchars($data_obat['Stok']) ?></td>
                <td><?= htmlspecialchars($data_obat['Dosis']) ?></td>
                <td><?= htmlspecialchars($data_obat['Keterangan']) ?></td>
                <td>
                    <?php if (!empty($data_obat['Gbr_obat'])): ?>
                        <img src="gambar/<?= htmlspecialchars($data_obat['Gbr_obat']) ?>" width="80">
                    <?php else: ?>
                        <i>Tidak ada gambar</i>
                    <?php endif; ?>
                </td>
                <td align="center">
                    <form method="post" onsubmit="return confirm('Yakin ingin menghapus obat ini?');">
                        <input type="hidden" name="nama_obat_hapus" value="<?= htmlspecialchars($data_obat['Nama_obat']) ?>">
                        <input type="submit" name="hapus" value="Hapus" style="background-color:#cc0000; color:white; padding:5px 15px; border:none; border-radius:5px; cursor:pointer;">
                    </form>
                </td>
            </tr>
        </table>
    <?php endif; ?>
</center>
</body>
</html>
