<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$pesan = "";

// ✅ Jika user menekan tombol hapus
if (isset($_POST['hapus']) && isset($_POST['id_hapus'])) {
    $id_hapus = (int)$_POST['id_hapus'];
    $stmt = $conn->prepare("DELETE FROM pasien WHERE no_id=?");
    $stmt->bind_param("i", $id_hapus);
    if ($stmt->execute()) {
        $pesan = "<div class='success'>✅ Data pasien berhasil dihapus.</div>";
    } else {
        $pesan = "<div class='error'>❌ Gagal menghapus data pasien.</div>";
    }
    $stmt->close();
}

// 🔍 Ambil semua data pasien
$result = $conn->query("SELECT no_id, Nama_pasien, Kelamin, Umur, Alamat, No_hape, Keterangan FROM pasien ORDER BY Nama_pasien ASC");

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Pasien</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background: #f4f7fb;
        color: #333;
        margin: 0;
        padding: 0;
    }
    h1 {
        text-align: center;
        background: linear-gradient(135deg, #0099cc, #00b386);
        color: white;
        padding: 20px;
        margin: 0;
        box-shadow: 0 2px 5px rgba(0,0,0,0.2);
    }
    .container {
        width: 90%;
        margin: 30px auto;
        background: white;
        border-radius: 12px;
        padding: 20px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    table {
        border-collapse: collapse;
        width: 100%;
        font-size: 14px;
    }
    th, td {
        border: 1px solid #ddd;
        padding: 10px;
        text-align: center;
    }
    th {
        background: #00a8a8;
        color: white;
    }
    tr:nth-child(even) {
        background: #f2f2f2;
    }
    tr:hover {
        background: #e8f8f5;
    }
    .btn {
        padding: 6px 12px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        text-decoration: none;
        font-size: 13px;
    }
    .btn-edit {
        background: #ffb600;
        color: white;
    }
    .btn-edit:hover {
        background: #e0a100;
    }
    .btn-hapus {
        background: #ff4d4d;
        color: white;
    }
    .btn-hapus:hover {
        background: #d93636;
    }
    .success {
        background: #d9fdd3;
        color: #006600;
        padding: 10px;
        border-radius: 6px;
        margin-bottom: 15px;
        text-align: center;
    }
    .error {
        background: #ffe0e0;
        color: #990000;
        padding: 10px;
        border-radius: 6px;
        margin-bottom: 15px;
        text-align: center;
    }
    .footer {
        text-align: center;
        margin-top: 20px;
    }
    input[type=text] {
        padding: 6px;
        border-radius: 5px;
        border: 1px solid #ccc;
        width: 250px;
    }
    input[type=submit] {
        padding: 6px 12px;
        background: #0099cc;
        color: white;
        border: none;
        border-radius: 5px;
        cursor: pointer;
    }
    input[type=submit]:hover {
        background: #007a99;
    }
</style>
</head>
<body>

<h1>🩺 Data Pasien</h1>
<div class="container">
    <?php echo $pesan; ?>

    <form method="post" style="text-align:center; margin-bottom:20px;">
        <input type="text" name="carinama" placeholder="Cari nama pasien..." />
        <input type="submit" value="Cari">
    </form>

    <table>
        <tr>
            <th>No</th>
            <th>Nama Pasien</th>
            <th>Kelamin</th>
            <th>Umur</th>
            <th>Alamat</th>
            <th>No. Hape</th>
            <th>Keterangan</th>
            <th>Aksi</th>
        </tr>
        <?php
        if ($result->num_rows > 0) {
            $no = 1;
            while ($row = $result->fetch_assoc()) {
                echo "<tr>
                    <td>".$no++."</td>
                    <td>".htmlspecialchars($row['Nama_pasien'])."</td>
                    <td>".htmlspecialchars($row['Kelamin'])."</td>
                    <td>".htmlspecialchars($row['Umur'])."</td>
                    <td>".htmlspecialchars($row['Alamat'])."</td>
                    <td>".htmlspecialchars($row['No_hape'])."</td>
                    <td>".htmlspecialchars($row['Keterangan'])."</td>
                    <td>
                        <a href='edit_pasien.php?id=".$row['no_id']."' class='btn btn-edit'>✏️ Edit</a>
                        <form method='post' style='display:inline;'>
                            <input type='hidden' name='id_hapus' value='".$row['no_id']."'>
                            <button type='submit' name='hapus' class='btn btn-hapus' onclick='return confirm(\"Yakin ingin menghapus data ini?\");'>🗑️ Hapus</button>
                        </form>
                    </td>
                </tr>";
            }
        } else {
            echo "<tr><td colspan='8' style='color:red;'>Tidak ada data pasien.</td></tr>";
        }
        ?>
    </table>

    <div class="footer">
        <br><a href="dashboard.php">🏠 Kembali ke Dashboard</a>
    </div>
</div>

</body>
</html>
