<?php
session_start();
include 'db.php';

// 🔒 Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// 🔧 Proses form jika dikirim
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $nama_dokter = trim($_POST['dokter'] ?? '');
    $ahli        = trim($_POST['ahli'] ?? '');
    $alamat      = trim($_POST['alamat'] ?? '');
    $no_hape     = trim($_POST['telp'] ?? '');
    $ket         = trim($_POST['ket'] ?? '');

    // 🔍 Validasi sederhana
    if ($nama_dokter === '' || $ahli === '' || $alamat === '' || $no_hape === '') {
        $pesan = "<p style='color:red;'>⚠️ Harap isi semua kolom wajib!</p>";
    } else {
        $conn = new mysqli($servername, $username, $password, $database);

        if ($conn->connect_error) {
            die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
        }

        $stmt = $conn->prepare("
            INSERT INTO dokter (Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan)
            VALUES (?, ?, ?, ?, ?)
        ");

        if (!$stmt) {
            die("<p style='color:red;'>Query error: " . htmlspecialchars($conn->error) . "</p>");
        }

        $stmt->bind_param("sssss", $nama_dokter, $ahli, $alamat, $no_hape, $ket);

        if ($stmt->execute()) {
            $pesan = "<p style='color:green;'>✅ Penambahan data dokter berhasil!</p>";
        } else {
            $pesan = "<p style='color:red;'>❌ Penambahan data dokter gagal: " . htmlspecialchars($stmt->error) . "</p>";
        }

        $stmt->close();
        $conn->close();
    }
}
?>

<html>
<head>
<title>Tambah Dokter Baru</title>
<style>
body {
    font-family: Verdana;
    background: #f5f5f5;
}
.container {
    width: 600px;
    margin: 50px auto;
    background: white;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 0 10px #aaa;
}
input[type=text], textarea {
    width: 100%;
    padding: 8px;
    font-size: 14px;
    border-radius: 5px;
    border: 1px solid #ccc;
}
input[type=submit] {
    background: #007bff;
    color: white;
    font-size: 16px;
    padding: 10px 25px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}
input[type=submit]:hover {
    background: #0056b3;
}
a {
    text-decoration: none;
    color: #007bff;
}
a:hover {
    text-decoration: underline;
}
</style>
</head>

<body>
<div class="container">
<center>
<h2>🩺 Tambah Data Dokter Baru</h2>
<?php if (isset($pesan)) echo $pesan; ?>
<form method="post">
<label>Nama Dokter:</label><br>
<input type="text" name="dokter" required><br><br>

<label>Spesialis:</label><br>
<input type="text" name="ahli" required><br><br>

<label>Alamat Dokter:</label><br>
<input type="text" name="alamat" required><br><br>

<label>Nomor HP:</label><br>
<input type="text" name="telp" required><br><br>

<label>Keterangan:</label><br>
<textarea name="ket" cols="50" rows="5"></textarea><br><br>

<input type="submit" value="Tambah Dokter"><br><br>
<a href="dashboard.php">← Kembali ke Dashboard</a>
</form>
</center>
</div>
</body>
</html>
