<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
include 'db.php';

// 🔒 Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// 🔗 Koneksi database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// ======================================================
// 🟢 TAMBAH DATA OBAT
// ======================================================
if (isset($_POST['tambah'])) {
    $nama_obat   = trim($_POST['obat']);
    $kodebar     = trim($_POST['kodebar']);
    $kategori    = trim($_POST['kategori']);
    $harga_asli  = intval($_POST['harga_asli']);
    $harga_jual  = intval($_POST['harga_jual']);
    $stok        = intval($_POST['stok']);
    $dosis       = trim($_POST['dosis']);
    $ket         = trim($_POST['ket']);
    $nama_file   = "default.png";

    $target_dir = "gambar/";
    if (!is_dir($target_dir)) mkdir($target_dir, 0777, true);

    if (!empty($_FILES["gbr_obat"]["name"])) {
        $nama_file = basename($_FILES["gbr_obat"]["name"]);
        $target_file = $target_dir . $nama_file;
        move_uploaded_file($_FILES["gbr_obat"]["tmp_name"], $target_file);
    }

    $stmt = $conn->prepare("INSERT INTO obat 
        (Kodebar, Nama_obat, Kategori, Harga_asli_obat, Harga_jual_obat, Stok, Dosis, Keterangan, Gbr_obat)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssiiisss", 
        $kodebar, $nama_obat, $kategori, $harga_asli, $harga_jual, $stok, $dosis, $ket, $nama_file
    );
    $stmt->execute();
    $stmt->close();

    echo "<script>alert('✅ Data obat berhasil ditambahkan!');</script>";
}

// ======================================================
// 🟡 EDIT DATA OBAT
// ======================================================
if (isset($_POST['update'])) {
    $id          = intval($_POST['id']);
    $nama_obat   = trim($_POST['obat']);
    $kodebar     = trim($_POST['kodebar']);
    $kategori    = trim($_POST['kategori']);
    $harga_asli  = intval($_POST['harga_asli']);
    $harga_jual  = intval($_POST['harga_jual']);
    $stok        = intval($_POST['stok']);
    $dosis       = trim($_POST['dosis']);
    $ket         = trim($_POST['ket']);
    $nama_file   = trim($_POST['gbr_lama']);

    if (!empty($_FILES["gbr_obat"]["name"])) {
        $nama_file = basename($_FILES["gbr_obat"]["name"]);
        $target_dir = "gambar/";
        move_uploaded_file($_FILES["gbr_obat"]["tmp_name"], $target_dir . $nama_file);
    }

    $stmt = $conn->prepare("UPDATE obat 
        SET Kodebar=?, Nama_obat=?, Kategori=?, Harga_asli_obat=?, Harga_jual_obat=?, 
            Stok=?, Dosis=?, Keterangan=?, Gbr_obat=?
        WHERE no_id=?");
    $stmt->bind_param("sssiiisssi", 
        $kodebar, $nama_obat, $kategori, $harga_asli, $harga_jual, $stok, $dosis, $ket, $nama_file, $id
    );
    $stmt->execute();
    $stmt->close();

    echo "<script>alert('✏️ Data obat berhasil diperbarui!');</script>";
}

// ======================================================
// 🔴 HAPUS DATA OBAT
// ======================================================
if (isset($_GET['hapus'])) {
    $id = intval($_GET['hapus']);
    $conn->query("DELETE FROM obat WHERE no_id = $id");
    echo "<script>alert('🗑️ Data obat berhasil dihapus!');</script>";
}

// ======================================================
// 📋 AMBIL SEMUA DATA OBAT
// ======================================================
$result = $conn->query("SELECT * FROM obat ORDER BY Nama_obat ASC");
?>

<html>
<head>
<title>Manajemen Data Obat</title>
<style>
body { font-family: Verdana; background-color: #f2f7ff; }
h2 { color: #007bff; }
form {
    background-color: #fff;
    width: 600px;
    padding: 20px;
    border-radius: 10px;
    box-shadow: 0 0 10px #ccc;
    margin-bottom: 40px;
}
input, textarea {
    padding: 6px;
    border-radius: 4px;
    border: 1px solid #ccc;
    width: 90%;
}
input[type=submit] {
    background-color: #007bff;
    color: white;
    font-weight: bold;
    border: none;
    cursor: pointer;
    padding: 8px 20px;
    width: 50%;
}
input[type=submit]:hover {
    background-color: #0056b3;
}
table {
    border-collapse: collapse;
    width: 95%;
    background-color: #fff;
    box-shadow: 0 0 10px #ccc;
}
th, td {
    padding: 8px;
    border: 1px solid #ddd;
    text-align: center;
}
th {
    background-color: #007bff;
    color: white;
}
img {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 5px;
}
.btn {
    padding: 4px 8px;
    border-radius: 4px;
    color: white;
    text-decoration: none;
}
.btn-edit { background-color: #28a745; }
.btn-hapus { background-color: #dc3545; }
</style>
</head>

<body>
<center>
<h2>💊 Data Obat</h2>

<?php
// ======================================================
// ✏️ MODE EDIT
// ======================================================
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $edit = $conn->query("SELECT * FROM obat WHERE no_id=$id")->fetch_assoc();
    echo "<form method='post' enctype='multipart/form-data'>
        <h3>✏️ Edit Data Obat</h3>
        <input type='hidden' name='id' value='{$edit['no_id']}'>
        <input type='hidden' name='gbr_lama' value='{$edit['Gbr_obat']}'>
        Nama Obat:<br><input type='text' name='obat' value='{$edit['Nama_obat']}' required><br><br>
        Barcode:<br><input type='text' name='kodebar' value='{$edit['Kodebar']}' required><br><br>
        Kategori:<br>
        <input type='radio' name='kategori' value='resep' ".($edit['Kategori']=='resep'?'checked':'')."> Dengan Resep
        <input type='radio' name='kategori' value='bebas' ".($edit['Kategori']=='bebas'?'checked':'')."> Tanpa Resep<br><br>
        Harga Asli:<br><input type='number' name='harga_asli' value='{$edit['Harga_asli_obat']}' required><br><br>
        Harga Jual:<br><input type='number' name='harga_jual' value='{$edit['Harga_jual_obat']}' required><br><br>
        Stok:<br><input type='number' name='stok' value='{$edit['Stok']}' required><br><br>
        Dosis:<br><input type='text' name='dosis' value='{$edit['Dosis']}' required><br><br>
        Keterangan:<br><textarea name='ket' rows='4' cols='40'>{$edit['Keterangan']}</textarea><br><br>
        Gambar Baru:<br><input type='file' name='gbr_obat' accept='image/*'><br>
        <img src='gambar/{$edit['Gbr_obat']}'><br><br>
        <input type='submit' name='update' value='Simpan Perubahan'>
        <a href='obat.php'>Batal</a>
    </form>";
}
// ======================================================
// ➕ MODE TAMBAH
// ======================================================
else {
    echo "<form method='post' enctype='multipart/form-data'>
        <h3>➕ Tambah Obat Baru</h3>
        Nama Obat:<br><input type='text' name='obat' required><br><br>
        Barcode:<br><input type='text' name='kodebar' required><br><br>
        Kategori:<br>
        <input type='radio' name='kategori' value='resep' required> Dengan Resep
        <input type='radio' name='kategori' value='bebas'> Tanpa Resep<br><br>
        Harga Asli:<br><input type='number' name='harga_asli' required><br><br>
        Harga Jual:<br><input type='number' name='harga_jual' required><br><br>
        Stok:<br><input type='number' name='stok' required><br><br>
        Dosis:<br><input type='text' name='dosis' required><br><br>
        Keterangan:<br><textarea name='ket' rows='4' cols='40'></textarea><br><br>
        Gambar Obat:<br><input type='file' name='gbr_obat' accept='image/*'><br><br>
        <input type='submit' name='tambah' value='Simpan Obat'>
    </form>";
}
?>

<html>
<body>
<br><a href="dashboard.php">🏠 Kembali ke Dashboard</a>
</center>
</body>
</html>
