<?php
session_start();
include 'db.php';
require('fpdf186/fpdf.php'); // pastikan file fpdf.php ada di folder ini

// Pastikan user login
if (!isset($_SESSION['username'])) {
   header("Location: login.php");
   exit;
}

// Koneksi database
$mysqli = new mysqli($servername, $username, $password, $database);
if ($mysqli->connect_error) {
   die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil data transaksi + harga obat
$sql = "
SELECT 
  transaksi.no_trans,
  transaksi.Tanggal_beli,
  pasien.Nama_pasien,
  obat.Nama_obat,
  dokter.Nama_dokter,
  transaksi.Jumlah_beli,
  transaksi.Total_harga,
  obat.Harga_asli_obat AS Harga_beli_obat,
  obat.Harga_jual_obat,
  transaksi.Keterangan,
  transaksi.Lunas
FROM transaksi
LEFT JOIN pasien ON transaksi.No_pasien = pasien.no_id
LEFT JOIN obat ON transaksi.No_obat = obat.no_id
LEFT JOIN dokter ON transaksi.No_dokter = dokter.no_id
ORDER BY transaksi.Tanggal_beli DESC
";

$result = $mysqli->query($sql);

$total_beli = 0;
$total_jual = 0;
$keuntungan = 0;

// === Jika tombol PDF ditekan ===
if (isset($_GET['pdf'])) {

    class PDF extends FPDF {
        function Header() {
            $this->SetFont('Arial','B',14);
            $this->Cell(0,10,'LAPORAN KEUNTUNGAN APOTEK',0,1,'C');
            $this->Ln(5);

            $this->SetFont('Arial','B',9);
            $this->SetFillColor(0,102,204);
            $this->SetTextColor(255);
            $this->Cell(20,8,'No.Trans',1,0,'C',true);
            $this->Cell(30,8,'Tanggal',1,0,'C',true);
            $this->Cell(30,8,'Pasien',1,0,'C',true);
            $this->Cell(30,8,'Dokter',1,0,'C',true);
            $this->Cell(30,8,'Obat',1,0,'C',true);
            $this->Cell(20,8,'Jumlah',1,0,'C',true);
            $this->Cell(25,8,'Harga Beli',1,0,'C',true);
            $this->Cell(25,8,'Harga Jual',1,0,'C',true);
            $this->Cell(25,8,'Total',1,0,'C',true);
            $this->Ln();
        }
    }

    $pdf = new PDF('L','mm','A4');
    $pdf->AddPage();
    $pdf->SetFont('Arial','',8);

    while ($row = $result->fetch_assoc()) {
        $modal = $row['Jumlah_beli'] * $row['Harga_beli_obat'];
        $total_beli += $modal;
        $total_jual += $row['Total_harga'];

        $pdf->Cell(20,7,$row['no_trans'],1);
        $pdf->Cell(30,7,$row['Tanggal_beli'],1);
        $pdf->Cell(30,7,substr($row['Nama_pasien'],0,15),1);
        $pdf->Cell(30,7,substr($row['Nama_dokter'],0,15),1);
        $pdf->Cell(30,7,substr($row['Nama_obat'],0,15),1);
        $pdf->Cell(20,7,$row['Jumlah_beli'],1,0,'C');
        $pdf->Cell(25,7,'Rp '.number_format($row['Harga_beli_obat'],0,',','.'),1,0,'R');
        $pdf->Cell(25,7,'Rp '.number_format($row['Harga_jual_obat'],0,',','.'),1,0,'R');
        $pdf->Cell(25,7,'Rp '.number_format($row['Total_harga'],0,',','.'),1,0,'R');
        $pdf->Ln();
    }

    $keuntungan = $total_jual - $total_beli;

    $pdf->SetFont('Arial','B',10);
    $pdf->Ln(5);
    $pdf->Cell(0,8,'TOTAL MODAL: Rp '.number_format($total_beli,0,',','.'),0,1,'L');
    $pdf->Cell(0,8,'TOTAL PENJUALAN: Rp '.number_format($total_jual,0,',','.'),0,1,'L');
    $pdf->Cell(0,8,'KEUNTUNGAN BERSIH: Rp '.number_format($keuntungan,0,',','.'),0,1,'L');

    $pdf->Output('I', 'Laporan_Keuntungan_Apotek.pdf');
    exit;
}

// === Jika bukan mode PDF, tampilkan HTML biasa ===
echo "<html><head>
<title>Laporan Keuntungan Apotek</title>
<style>
body { font-family: Verdana; background: #f6f8fa; color: #333; }
h1 { text-align: center; color: #0059b3; }
table { border-collapse: collapse; width: 90%; margin: 30px auto; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
th, td { border: 1px solid #ddd; padding: 8px; text-align: center; }
th { background-color: #0059b3; color: white; }
tr:nth-child(even) { background-color: #f2f2f2; }
tfoot td { font-weight: bold; background-color: #e6f0ff; }
.summary { text-align: center; margin-top: 30px; font-size: 20px; }
.summary span { display: block; margin: 5px 0; }
.button { text-align:center; margin-top:40px; }
a { text-decoration: none; color: white; background: #0073e6; padding: 10px 20px; border-radius: 6px; }
a:hover { background: #0059b3; }
</style>
</head><body>";

echo "<h1>LAPORAN KEUNTUNGAN APOTEK</h1>";
echo "<table>
<tr>
<th>No. Transaksi</th>
<th>Tanggal Beli</th>
<th>Pasien</th>
<th>Dokter</th>
<th>Obat</th>
<th>Jumlah Beli</th>
<th>Harga Beli</th>
<th>Harga Jual</th>
<th>Total Harga</th>
<th>Keterangan</th>
<th>Lunas</th>
</tr>";

while ($row = $result->fetch_assoc()) {
    $modal = $row['Jumlah_beli'] * $row['Harga_beli_obat'];
    $total_beli += $modal;
    $total_jual += $row['Total_harga'];

    echo "<tr>";
    echo "<td>" . htmlspecialchars($row['no_trans']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Tanggal_beli']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Nama_pasien']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Nama_dokter']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Nama_obat']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Jumlah_beli']) . "</td>";
    echo "<td>Rp " . number_format($row['Harga_beli_obat'], 0, ',', '.') . "</td>";
    echo "<td>Rp " . number_format($row['Harga_jual_obat'], 0, ',', '.') . "</td>";
    echo "<td>Rp " . number_format($row['Total_harga'], 0, ',', '.') . "</td>";
    echo "<td>" . htmlspecialchars($row['Keterangan']) . "</td>";
    echo "<td>" . ($row['Lunas'] ? '✅' : '❌') . "</td>";
    echo "</tr>";
}

$keuntungan = $total_jual - $total_beli;

echo "<tfoot>
<tr>
<td colspan='6'>TOTAL</td>
<td>Rp " . number_format($total_beli, 0, ',', '.') . "</td>
<td></td>
<td>Rp " . number_format($total_jual, 0, ',', '.') . "</td>
<td colspan='2'></td>
</tr>
</tfoot>";
echo "</table>";

echo "<div class='summary'>
<span><b>Total Penjualan:</b> Rp " . number_format($total_jual, 0, ',', '.') . "</span>
<span><b>Total Modal Pembelian:</b> Rp " . number_format($total_beli, 0, ',', '.') . "</span>
<span><b>Keuntungan Bersih:</b> <font color='green'><b>Rp " . number_format($keuntungan, 0, ',', '.') . "</b></font></span>
</div>";

echo "<div class='button'>
<a href='?pdf=1'>🖨️ Cetak ke PDF</a>
&nbsp;&nbsp;&nbsp;
<a href='dashboard.php'>Kembali ke Dashboard</a>
</div>";

echo "</body></html>";

$mysqli->close();
?>
