<?php
session_start();
include 'db.php';

// 🔒 Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// 🔌 Koneksi database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$pesan = "";

// 🧩 Tambah atau Edit data obat
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kodebar = trim($_POST['kodebar']);
    $nama = trim($_POST['nama']);
    $kategori = trim($_POST['kategori']);
    $harga_beli = intval($_POST['harga_beli']);
    $harga_jual = intval($_POST['harga_jual']);
    $stok = intval($_POST['stok']);
    $dosis = trim($_POST['dosis']);
    $ket = trim($_POST['ket']);

    // upload gambar jika ada
    $gambar = "";
    if (!empty($_FILES['gambar']['name'])) {
        $target_dir = "gambar/";
        $nama_file = basename($_FILES["gambar"]["name"]);
        $target_file = $target_dir . $nama_file;
        move_uploaded_file($_FILES["gambar"]["tmp_name"], $target_file);
        $gambar = $nama_file;
    }

    // jika ada id berarti update
    if (!empty($_POST['id'])) {
        $id = intval($_POST['id']);
        if ($gambar) {
            $stmt = $conn->prepare("UPDATE obat SET Kodebar=?, Nama_obat=?, Kategori=?, Harga_asli_obat=?, Harga_jual_obat=?, Stok=?, Dosis=?, Keterangan=?, Gbr_obat=? WHERE no_id=?");
            $stmt->bind_param("sssiiisssi", $kodebar, $nama, $kategori, $harga_beli, $harga_jual, $stok, $dosis, $ket, $gambar, $id);
        } else {
            $stmt = $conn->prepare("UPDATE obat SET Kodebar=?, Nama_obat=?, Kategori=?, Harga_asli_obat=?, Harga_jual_obat=?, Stok=?, Dosis=?, Keterangan=? WHERE no_id=?");
            $stmt->bind_param("sssiiissi", $kodebar, $nama, $kategori, $harga_beli, $harga_jual, $stok, $dosis, $ket, $id);
        }
        $stmt->execute();
        $pesan = "✅ Data obat berhasil diperbarui!";
    } else {
        // tambah data baru
        $stmt = $conn->prepare("INSERT INTO obat (Kodebar, Nama_obat, Kategori, Harga_asli_obat, Harga_jual_obat, Stok, Dosis, Keterangan, Gbr_obat) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssiiisss", $kodebar, $nama, $kategori, $harga_beli, $harga_jual, $stok, $dosis, $ket, $gambar);
        $stmt->execute();
        $pesan = "✅ Data obat baru berhasil ditambahkan!";
    }
}

// 🗑️ Hapus data obat
if (isset($_GET['hapus'])) {
    $hapus_id = intval($_GET['hapus']);
    $stmt = $conn->prepare("DELETE FROM obat WHERE no_id=?");
    $stmt->bind_param("i", $hapus_id);
    $stmt->execute();
    $pesan = "🗑️ Data obat berhasil dihapus!";
}

// ✏️ Ambil data untuk form edit
$edit_data = null;
if (isset($_GET['edit'])) {
    $edit_id = intval($_GET['edit']);
    $stmt = $conn->prepare("SELECT * FROM obat WHERE no_id=?");
    $stmt->bind_param("i", $edit_id);
    $stmt->execute();
    $edit_data = $stmt->get_result()->fetch_assoc();
}

// 🔍 Ambil semua data obat
$result = $conn->query("SELECT * FROM obat ORDER BY Nama_obat ASC");
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Manajemen Data Obat</title>
<style>
body { font-family: Verdana; background: #f4f6f9; margin: 0; padding: 20px; text-align: center; }
h2 { background: #007bff; color: #fff; padding: 15px; border-radius: 10px; width: 80%; margin: auto; }
form { background: #fff; width: 70%; margin: 20px auto; padding: 15px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); text-align: left; }
table { border-collapse: collapse; width: 95%; margin: auto; background: #fff; }
th, td { border: 1px solid #ddd; padding: 8px; }
th { background: #007bff; color: white; }
tr:nth-child(even) { background: #f9f9f9; }
tr:hover { background: #e9f1ff; }
a { text-decoration: none; }
.tombol { color: #fff; padding: 5px 10px; border-radius: 5px; }
.edit { background: #17a2b8; }
.hapus { background: #dc3545; }
.tambah { background: #28a745; }
input, select, textarea { padding: 6px; width: 95%; margin: 4px 0; }
button { background: #007bff; color: #fff; border: none; padding: 8px 16px; border-radius: 5px; cursor: pointer; }
button:hover { background: #0056b3; }
img { border-radius: 8px; }
.pesan { background: #e0ffe4; color: #006400; padding: 8px; border-radius: 5px; width: 70%; margin: 10px auto; }
</style>
</head>
<body>

<h2>💊 Manajemen Data Obat</h2>

<?php if ($pesan): ?>
<div class="pesan"><?= htmlspecialchars($pesan) ?></div>
<?php endif; ?>

<form method="post" enctype="multipart/form-data">
<h3><?= $edit_data ? "✏️ Edit Data Obat" : "➕ Tambah Obat Baru" ?></h3>
<input type="hidden" name="id" value="<?= $edit_data['no_id'] ?? '' ?>">
<label>Kode Barcode:</label><br>
<input type="text" name="kodebar" value="<?= htmlspecialchars($edit_data['Kodebar'] ?? '') ?>" required><br>

<label>Nama Obat:</label><br>
<input type="text" name="nama" value="<?= htmlspecialchars($edit_data['Nama_obat'] ?? '') ?>" required><br>

<label>Kategori:</label><br>
<input type="text" name="kategori" value="<?= htmlspecialchars($edit_data['Kategori'] ?? '') ?>"><br>

<label>Harga Beli:</label><br>
<input type="number" name="harga_beli" value="<?= htmlspecialchars($edit_data['Harga_asli_obat'] ?? '') ?>" required><br>

<label>Harga Jual:</label><br>
<input type="number" name="harga_jual" value="<?= htmlspecialchars($edit_data['Harga_jual_obat'] ?? '') ?>" required><br>

<label>Stok:</label><br>
<input type="number" name="stok" value="<?= htmlspecialchars($edit_data['Stok'] ?? '') ?>" required><br>

<label>Dosis:</label><br>
<input type="text" name="dosis" value="<?= htmlspecialchars($edit_data['Dosis'] ?? '') ?>"><br>

<label>Keterangan:</label><br>
<textarea name="ket"><?= htmlspecialchars($edit_data['Keterangan'] ?? '') ?></textarea><br>

<label>Gambar Obat:</label><br>
<input type="file" name="gambar"><br>
<?php if (!empty($edit_data['Gbr_obat'])): ?>
<img src="gambar/<?= htmlspecialchars($edit_data['Gbr_obat']) ?>" width="80">
<?php endif; ?><br><br>

<button type="submit"><?= $edit_data ? "Simpan Perubahan" : "Tambah Data" ?></button>
</form>

<h3>📋 Daftar Semua Obat</h3>
<table>
<tr>
<th>No</th>
<th>Nama Obat</th>
<th>Barcode</th>
<th>Kategori</th>
<th>Harga Beli</th>
<th>Harga Jual</th>
<th>Stok</th>
<th>Dosis</th>
<th>Keterangan</th>
<th>Gambar</th>
<th>Aksi</th>
</tr>

<?php
$no = 1;
while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $no++ . "</td>";
    echo "<td>" . htmlspecialchars($row['Nama_obat']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Kodebar']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Kategori']) . "</td>";
    echo "<td align='right'>" . number_format($row['Harga_asli_obat'], 0, ',', '.') . "</td>";
    echo "<td align='right'>" . number_format($row['Harga_jual_obat'], 0, ',', '.') . "</td>";
    echo "<td>" . htmlspecialchars($row['Stok']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Dosis']) . "</td>";
    echo "<td>" . htmlspecialchars($row['Keterangan']) . "</td>";
    if (!empty($row['Gbr_obat']) && file_exists("gambar/" . $row['Gbr_obat'])) {
        echo "<td><img src='gambar/" . htmlspecialchars($row['Gbr_obat']) . "' width='80'></td>";
    } else {
        echo "<td><i>-</i></td>";
    }
    echo "<td>
            <a class='tombol edit' href='?edit=" . $row['no_id'] . "'>Edit</a> 
            <a class='tombol hapus' href='?hapus=" . $row['no_id'] . "' onclick=\"return confirm('Yakin ingin menghapus data ini?');\">Hapus</a>
          </td>";
    echo "</tr>";
}
$conn->close();
?>
</table>

<br>
<a href="dashboard.php" class="tombol tambah">⬅️ Kembali ke Dashboard</a>

</body>
</html>
