<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Koneksi ke database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$pesan = "";
$edit_data = null;

// 🧩 Jika tombol hapus ditekan
if (isset($_POST['hapus'])) {
    $nama = trim($_POST['hapus']);
    $stmt = $conn->prepare("DELETE FROM pasien WHERE Nama_pasien = ?");
    $stmt->bind_param("s", $nama);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        $pesan = "✅ Data pasien <b>" . htmlspecialchars($nama) . "</b> berhasil dihapus.";
    } else {
        $pesan = "⚠️ Data pasien <b>" . htmlspecialchars($nama) . "</b> tidak ditemukan.";
    }
    $stmt->close();
}

// 🧩 Jika tombol edit ditekan (menampilkan form edit)
if (isset($_POST['edit'])) {
    $nama = trim($_POST['edit']);
    $stmt = $conn->prepare("SELECT Nama_pasien, Kelamin, Umur, Alamat, No_hape, Keterangan 
                            FROM pasien WHERE Nama_pasien = ?");
    $stmt->bind_param("s", $nama);
    $stmt->execute();
    $stmt->bind_result($n, $k, $u, $a, $t, $ket);
    if ($stmt->fetch()) {
        $edit_data = [
            'Nama_pasien' => $n,
            'Kelamin' => $k,
            'Umur' => $u,
            'Alamat' => $a,
            'No_hape' => $t,
            'Keterangan' => $ket
        ];
    } else {
        $pesan = "⚠️ Data pasien tidak ditemukan.";
    }
    $stmt->close();
}

// 🧩 Jika form edit disimpan
if (isset($_POST['update'])) {
    $nama_lama = trim($_POST['nama_lama']);
    $nama = trim($_POST['nama']);
    $kelamin = trim($_POST['kelamin']);
    $umur = trim($_POST['umur']);
    $alamat = trim($_POST['alamat']);
    $nohp = trim($_POST['nohp']);
    $ket = trim($_POST['keterangan']);

    $stmt = $conn->prepare("UPDATE pasien 
                            SET Nama_pasien=?, Kelamin=?, Umur=?, Alamat=?, No_hape=?, Keterangan=? 
                            WHERE Nama_pasien=?");
    $stmt->bind_param("sssssss", $nama, $kelamin, $umur, $alamat, $nohp, $ket, $nama_lama);
    if ($stmt->execute() && $stmt->affected_rows > 0) {
        $pesan = "✅ Data pasien <b>" . htmlspecialchars($nama) . "</b> berhasil diperbarui.";
    } else {
        $pesan = "⚠️ Tidak ada perubahan data.";
    }
    $stmt->close();
}

// 🔍 Ambil semua data pasien
$result = $conn->query("SELECT * FROM pasien ORDER BY Nama_pasien ASC");
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Data Pasien - Apotek Mekar Jaya</title>
    <style>
        body { font-family: Verdana, sans-serif; background-color: #f5f5f5; }
        table { border-collapse: collapse; margin: 20px auto; width: 95%; background: #fff; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        th, td { border: 1px solid #ccc; padding: 10px 15px; text-align: left; }
        th { background-color: #009879; color: white; }
        tr:nth-child(even) { background-color: #f2f2f2; }
        h2 { text-align: center; color: #009879; }
        .btn { padding: 6px 12px; border: none; border-radius: 4px; cursor: pointer; color: white; font-size: 13px; }
        .edit { background-color: #007bff; }
        .hapus { background-color: #dc3545; }
        .btn:hover { opacity: 0.8; }
        .center { text-align: center; }
        .topnav { text-align: center; margin: 20px; }
        .topnav a { text-decoration: none; color: white; background: #009879; padding: 10px 20px; border-radius: 5px; }
        .topnav a:hover { background: #007b6f; }
        form.edit-form { width: 50%; margin: 30px auto; background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 0 8px rgba(0,0,0,0.1); }
        form.edit-form input, textarea, select { width: 100%; padding: 8px; margin-bottom: 10px; border: 1px solid #ccc; border-radius: 4px; }
        form.edit-form button { background-color: #009879; color: white; padding: 10px 15px; border: none; border-radius: 5px; cursor: pointer; }
        .msg { text-align: center; margin-top: 10px; font-weight: bold; }
    </style>
</head>
<body>

<div class="topnav">
    <a href="dashboard.php">🏠 Kembali ke Dashboard</a>
</div>

<h2>📋 Daftar Data Pasien</h2>

<?php
if ($pesan) echo "<p class='msg'>$pesan</p>";

if ($edit_data): ?>
    <form method="post" class="edit-form">
        <h3>✏️ Edit Data Pasien</h3>
        <input type="hidden" name="nama_lama" value="<?= htmlspecialchars($edit_data['Nama_pasien']) ?>">
        Nama Pasien: <input type="text" name="nama" value="<?= htmlspecialchars($edit_data['Nama_pasien']) ?>" required>
        Jenis Kelamin:
        <select name="kelamin" required>
            <option value="Laki-laki" <?= ($edit_data['Kelamin'] == 'Laki-laki') ? 'selected' : '' ?>>Laki-laki</option>
            <option value="Perempuan" <?= ($edit_data['Kelamin'] == 'Perempuan') ? 'selected' : '' ?>>Perempuan</option>
        </select>
        Umur: <input type="number" name="umur" value="<?= htmlspecialchars($edit_data['Umur']) ?>" required>
        Alamat: <input type="text" name="alamat" value="<?= htmlspecialchars($edit_data['Alamat']) ?>" required>
        Nomor HP: <input type="text" name="nohp" value="<?= htmlspecialchars($edit_data['No_hape']) ?>" required>
        Keterangan: <textarea name="keterangan"><?= htmlspecialchars($edit_data['Keterangan']) ?></textarea>
        <button type="submit" name="update">💾 Simpan Perubahan</button>
    </form>
<?php endif; ?>

<?php
if ($result->num_rows > 0) {
    echo "<table>";
    echo "<tr>
            <th>Nama Pasien</th>
            <th>Jenis Kelamin</th>
            <th>Usia</th>
            <th>Alamat</th>
            <th>Nomor Hape</th>
            <th>Keterangan</th>
            <th class='center'>Aksi</th>
          </tr>";

    while ($row = $result->fetch_assoc()) {
        $nama_pasien = htmlspecialchars($row['Nama_pasien']);
        echo "<tr>
                <td>$nama_pasien</td>
                <td>" . htmlspecialchars($row['Kelamin']) . "</td>
                <td>" . htmlspecialchars($row['Umur']) . "</td>
                <td>" . htmlspecialchars($row['Alamat']) . "</td>
                <td>" . htmlspecialchars($row['No_hape']) . "</td>
                <td>" . htmlspecialchars($row['Keterangan']) . "</td>
                <td class='center'>
                    <form method='post' style='display:inline;'>
                        <button class='btn edit' type='submit' name='edit' value='$nama_pasien'>✏️ Edit</button>
                    </form>
                    <form method='post' style='display:inline;' onsubmit=\"return confirm('Yakin ingin menghapus $nama_pasien ?');\">
                        <button class='btn hapus' type='submit' name='hapus' value='$nama_pasien'>🗑️ Hapus</button>
                    </form>
                </td>
              </tr>";
    }
    echo "</table>";
} else {
    echo "<p style='text-align:center; color:red;'>Tidak ada data pasien.</p>";
}
$conn->close();
?>

</body>
</html>
