<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include 'db.php';

// isi file : trans1.php
// transaksi pakai barcode dan tanpa resep dokter

if (!isset($_SESSION['username'])) {
   header("Location: login.php");
   exit; 
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
   die("Koneksi gagal: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4"); // ✅ Hindari masalah collation

$pesan_error = "";
$hasil_obat = null;
$pesan_sukses = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $kodebar = trim($_POST['kodebar'] ?? '');

   // --- CARI DATA OBAT BERDASARKAN KODEBAR ---
   $stmt = $conn->prepare("SELECT no_id, Kodebar, Nama_obat, Kategori, Harga_asli_obat, 
      Harga_jual_obat, Stok, Dosis, Keterangan, Gbr_obat 
      FROM obat WHERE Kodebar = ?");
   $stmt->bind_param("s", $kodebar);
   $stmt->execute();
   $stmt->bind_result($no_id, $kodebar_db, $nama, $kat, $beli, $jual, $stok, $dosis, $ket, $gbr);
   $stmt->fetch();
   $stmt->close();
   
   $_SESSION['nama_obat'] = $nama;
   $_SESSION['nama_pasien'] = "-";
   $_SESSION['nama_dokter'] = "-";

   if (empty($nama)) {
      $pesan_error = "⚠️ Data obat dengan barcode <b>" . htmlspecialchars($kodebar) . "</b> tidak ditemukan!";
   } else {
      $hasil_obat = [
         'no_id' => $no_id,
         'kodebar' => $kodebar_db,
         'nama' => $nama,
         'kat' => $kat,
         'beli' => $beli,
         'jual' => $jual,
         'stok' => $stok,
         'dosis' => $dosis,
         'ket' => $ket,
         'gbr' => $gbr
      ];
   }

   // --- PROSES BELI ---
   if (isset($_POST['beli'])) {
       $no_pasien = 0;
       $no_dokter = 0;
       $no_obat = $no_id;
       $tanggal = date('Y-m-d H:i:s');
       $jml_beli = (int)($_POST['jumlah_beli'] ?? 0);
       $keterangan = "-";
       $lunas = 0;

       if ($stok <= 0) {
           $pesan_error = "❌ Stok obat habis, transaksi tidak dapat dilakukan.";
       } elseif ($jml_beli > $stok) {
           $pesan_error = "⚠️ Stok tidak mencukupi! Stok tersedia hanya $stok.";
       } elseif ($jml_beli <= 0) {
           $pesan_error = "⚠️ Jumlah pembelian tidak boleh nol atau negatif.";
       } else {
           $total_harga = $jual * $jml_beli;

           $stmt = $conn->prepare("INSERT INTO transaksi 
               (No_pasien, No_obat, No_dokter, Tanggal_beli, jumlah_beli, Total_harga, Keterangan, Lunas)
               VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
           $stmt->bind_param("iiisiisi", 
               $no_pasien, $no_obat, $no_dokter, $tanggal, $jml_beli, $total_harga, $keterangan, $lunas);

           if ($stmt->execute()) {
               $stok_baru = $stok - $jml_beli;
               $up = $conn->prepare("UPDATE obat SET Stok = ? WHERE no_id = ?");
               $up->bind_param("ii", $stok_baru, $no_id);
               $up->execute();
               $up->close();

               $pesan_sukses = "
               ✅ Transaksi berhasil disimpan!<br>
               📦 Stok obat telah dikurangi menjadi <b>$stok_baru</b>.<br>
               💰 Total harga: <b>Rp " . number_format($total_harga, 0, ',', '.') . "</b>";
           } else {
               $pesan_error = "❌ Gagal menyimpan transaksi: " . htmlspecialchars($stmt->error);
           }
           $stmt->close();
       }
   }
}

$conn->close();
?>

<html>
<head>
<title>Transaksi Obat Barcode - Apotek Mekar Jaya</title>
<style>
body {
   font-family: 'Verdana', sans-serif;
   background: linear-gradient(135deg, #e3f2fd, #bbdefb);
   margin: 0;
   padding: 0;
   color: #333;
}
.container {
   width: 90%;
   max-width: 700px;
   margin: 50px auto;
   background: #fff;
   border-radius: 15px;
   box-shadow: 0 5px 20px rgba(0,0,0,0.1);
   padding: 30px;
   text-align: center;
}
h1 {
   color: #1565c0;
   font-size: 28px;
   margin-bottom: 20px;
}
input[type="text"],
input[type="number"] {
   width: 80%;
   padding: 10px;
   margin: 8px 0;
   border-radius: 8px;
   border: 1px solid #ccc;
   font-size: 14px;
   transition: all 0.2s;
}
input[type="text"]:focus,
input[type="number"]:focus {
   border-color: #1976d2;
   box-shadow: 0 0 5px rgba(25,118,210,0.5);
   outline: none;
}
.btn {
   background: #1976d2;
   color: white;
   border: none;
   padding: 10px 25px;
   border-radius: 8px;
   cursor: pointer;
   font-size: 16px;
   transition: 0.3s;
}
.btn:hover { background: #0d47a1; }
.notif {
   margin: 15px auto;
   padding: 15px;
   border-radius: 10px;
   width: 90%;
   font-size: 16px;
}
.error {
   background: #ffebee;
   color: #c62828;
   border: 1px solid #ef9a9a;
}
.success {
   background: #e8f5e9;
   color: #2e7d32;
   border: 1px solid #a5d6a7;
}
img {
   border-radius: 10px;
   box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}
a {
   text-decoration: none;
   color: #1565c0;
   font-weight: bold;
}
a:hover {
   color: #0d47a1;
}
</style>
<script>
window.onload = function() {
    document.getElementById("kodebar").focus();
};
</script>
</head>
<body>
<div class="container">
   <h1>🧾 Transaksi Obat (Barcode)</h1>

   <form method="post">
      <label>Masukkan Barcode:</label><br>
      <input type="text" id="kodebar" name="kodebar" value="<?php echo isset($_POST['kodebar']) ? htmlspecialchars($_POST['kodebar']) : ''; ?>" required><br>
      <input type="submit" value="Cari" class="btn">
   </form>

   <?php if ($pesan_error): ?>
      <div class="notif error"><?php echo $pesan_error; ?></div>
   <?php endif; ?>

   <?php if ($pesan_sukses): ?>
      <div class="notif success"><?php echo $pesan_sukses; ?></div>
   <?php endif; ?>

   <?php if ($hasil_obat): ?>
      <h2>💊 Detail Obat</h2>
      <p><b>Nama:</b> <?php echo htmlspecialchars($hasil_obat['nama']); ?></p>
      <p><b>Kategori:</b> <?php echo htmlspecialchars($hasil_obat['kat']); ?></p>
      <p><b>Harga Beli:</b> Rp <?php echo number_format($hasil_obat['beli'], 0, ',', '.'); ?></p>
      <p><b>Harga Jual:</b> Rp <?php echo number_format($hasil_obat['jual'], 0, ',', '.'); ?></p>
      <p><b>Stok:</b> <?php echo htmlspecialchars($hasil_obat['stok']); ?></p>
      <p><b>Dosis:</b> <?php echo htmlspecialchars($hasil_obat['dosis']); ?></p>
      <p><b>Keterangan:</b> <?php echo htmlspecialchars($hasil_obat['ket']); ?></p>
      <img src="gambar/<?php echo htmlspecialchars($hasil_obat['gbr']); ?>" width="150" alt="Gambar Obat"><br><br>

      <?php if ($hasil_obat['stok'] > 0): ?>
         <form method="post">
            <input type="hidden" name="kodebar" value="<?php echo htmlspecialchars($hasil_obat['kodebar']); ?>">
            <label>Jumlah Beli:</label><br>
            <input type="number" name="jumlah_beli" min="1" max="<?php echo htmlspecialchars($hasil_obat['stok']); ?>" required><br>
            <input type="submit" name="beli" value="💰 Beli Sekarang" class="btn"><br><br>
         </form>
      <?php else: ?>
         <div class="notif error">❌ Stok obat habis, tidak bisa dijual.</div>
      <?php endif; ?>

      <a href="trans1.php">🔄 Beli Lagi</a> | <a href="dashboard.php">🏠 Kembali ke Dashboard</a>
   <?php endif; ?>
</div>
</body>
</html>
