<?php
session_start();
include 'db.php';

// 🔒 Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$pesan = "";
$obat = $kodebar = $kat = $asli = $jual = $stok = $dosis = $ket = $gbr = "";
$hasil_cari = [];

// --- Jika form pencarian dikirim ---
if (isset($_POST['tampilkan']) && !isset($_POST['pilih_obat'])) {
    $nama_obat = trim($_POST['nama_obat'] ?? '');

    $conn = new mysqli($servername, $username, $password, $database);
    if ($conn->connect_error) {
        die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
    }

    // 🔍 Pencarian tidak case-sensitive dan cukup sebagian kata
    $like = '%' . strtolower($nama_obat) . '%';
    $stmt = $conn->prepare("SELECT Nama_obat FROM obat WHERE LOWER(Nama_obat) LIKE ?");
    $stmt->bind_param("s", $like);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $hasil_cari[] = $row['Nama_obat'];
    }

    if (empty($hasil_cari)) {
        $pesan = "⚠️ Tidak ditemukan obat yang mengandung kata <b>" . htmlspecialchars($nama_obat) . "</b>.";
    } elseif (count($hasil_cari) === 1) {
        $_POST['pilih_obat'] = $hasil_cari[0]; // langsung pilih otomatis
    } else {
        $pesan = "🔎 Ditemukan " . count($hasil_cari) . " obat. Silakan pilih:";
    }

    $stmt->close();
    $conn->close();
}

// --- Jika user sudah memilih salah satu obat ---
if (isset($_POST['pilih_obat'])) {
    $nama_obat = $_POST['pilih_obat'];

    $conn = new mysqli($servername, $username, $password, $database);
    $stmt = $conn->prepare("SELECT Nama_obat, Kodebar, Kategori, Harga_asli_obat, Harga_jual_obat, 
        Stok, Dosis, Keterangan, Gbr_obat FROM obat WHERE Nama_obat = ?");
    $stmt->bind_param("s", $nama_obat);
    $stmt->execute();
    $stmt->bind_result($obat, $kodebar, $kat, $asli, $jual, $stok, $dosis, $ket, $gbr);
    $stmt->fetch();
    $stmt->close();
    $conn->close();

    if (!$obat) {
        $pesan = "⚠️ Data obat tidak ditemukan.";
    } else {
        $pesan = "✅ Data obat ditemukan: <b>" . htmlspecialchars($obat) . "</b>";
    }
}

// --- Jika form update dikirim ---
if (isset($_POST['update'])) {
    $nama_lama  = trim($_POST['nama_lama'] ?? '');
    $nama_baru  = trim($_POST['obat'] ?? '');
    $kodebar    = trim($_POST['kodebar'] ?? '');
    $kategori   = trim($_POST['kategori'] ?? '');
    $harga_asli = (int) ($_POST['harga_asli'] ?? 0);
    $harga_jual = (int) ($_POST['harga_jual'] ?? 0);
    $stok       = (int) ($_POST['stok'] ?? 0);
    $dosis      = trim($_POST['dosis'] ?? '');
    $keterangan = trim($_POST['ket'] ?? '');
    $target_dir = "gambar/";
    $gbr_baru = "";

    $conn = new mysqli($servername, $username, $password, $database);
    if ($conn->connect_error) {
        die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
    }

    // Ambil gambar lama
    $stmt = $conn->prepare("SELECT Gbr_obat FROM obat WHERE Nama_obat = ?");
    $stmt->bind_param("s", $nama_lama);
    $stmt->execute();
    $stmt->bind_result($gambar_lama);
    $stmt->fetch();
    $stmt->close();

    // Upload file baru jika ada
    if (isset($_FILES["gbr_obat"]) && $_FILES["gbr_obat"]["tmp_name"] != "") {
        $nama_file = basename($_FILES["gbr_obat"]["name"]);
        $target_file = $target_dir . $nama_file;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $uploadOk = 1;

        $check = getimagesize($_FILES["gbr_obat"]["tmp_name"]);
        if ($check === false) {
            $pesan .= "❌ File bukan gambar.<br>";
            $uploadOk = 0;
        }

        if (file_exists($target_file)) {
            $pesan .= "⚠️ File sudah ada, gunakan nama file lain.<br>";
            $uploadOk = 0;
        }

        if ($_FILES["gbr_obat"]["size"] > 5000000) {
            $pesan .= "❌ Ukuran file terlalu besar (maks. 5MB).<br>";
            $uploadOk = 0;
        }

        if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
            $pesan .= "❌ Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["gbr_obat"]["tmp_name"], $target_file)) {
                $pesan .= "✅ File berhasil diupload: " . htmlspecialchars($nama_file) . "<br>";
                $gbr_baru = $nama_file;

                // Hapus file lama jika ada
                if ($gambar_lama && file_exists($target_dir . $gambar_lama)) {
                    unlink($target_dir . $gambar_lama);
                }
            } else {
                $pesan .= "❌ Gagal upload gambar.<br>";
                $gbr_baru = $gambar_lama;
            }
        } else {
            $gbr_baru = $gambar_lama;
        }
    } else {
        $gbr_baru = $gambar_lama;
    }

    // Update data obat
    $stmt = $conn->prepare("
        UPDATE obat 
        SET Nama_obat = ?, Kodebar = ?, Kategori = ?, Harga_asli_obat = ?, Harga_jual_obat = ?, 
            Stok = ?, Dosis = ?, Keterangan = ?, Gbr_obat = ?
        WHERE LOWER(Nama_obat) = LOWER(?)
    ");
    $stmt->bind_param("sssiiissss", 
        $nama_baru, $kodebar, $kategori, $harga_asli, $harga_jual, 
        $stok, $dosis, $keterangan, $gbr_baru, $nama_lama
    );

    if ($stmt->execute()) {
        $pesan .= "<br>✅ Data obat berhasil diperbarui!";
    } else {
        $pesan .= "<br>❌ Gagal memperbarui data obat: " . htmlspecialchars($stmt->error);
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Edit Data Obat</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background-color: #f8f9fa;
    color: #333;
}
.container {
    width: 800px;
    margin: 40px auto;
    background: white;
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 0 10px rgba(0,0,0,0.2);
}
h2 { color: #007bff; }
input, textarea {
    width: 90%;
    padding: 8px;
    border-radius: 5px;
    border: 1px solid #ccc;
}
button, input[type=submit] {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}
button:hover, input[type=submit]:hover { background-color: #0056b3; }
.message { background: #eef; padding: 10px; margin-bottom: 20px; border-radius: 6px; }
a { text-decoration: none; color: #007bff; }
</style>
</head>
<body>
<div class="container">
<h2>Edit Data Obat</h2>

<?php if ($pesan): ?>
<div class="message"><?= $pesan; ?></div>
<?php endif; ?>

<!-- Form cari obat -->
<form method="post">
    <label>Nama obat yang akan diubah datanya:</label><br><br>
    <input type="text" name="nama_obat" size="30" required>
    <br><br>
    <input type="submit" name="tampilkan" value="Cari Obat">
</form>

<?php if (!empty($hasil_cari) && count($hasil_cari) > 1): ?>
<hr>
<form method="post">
<input type="hidden" name="nama_obat" value="<?= htmlspecialchars($_POST['nama_obat']); ?>">
<?php foreach ($hasil_cari as $nama): ?>
    <button type="submit" name="pilih_obat" value="<?= htmlspecialchars($nama); ?>" style="margin:5px;"><?= htmlspecialchars($nama); ?></button><br>
<?php endforeach; ?>
</form>
<?php endif; ?>

<?php if ($obat): ?>
<hr>
<form method="post" enctype="multipart/form-data">
    <input type="hidden" name="nama_lama" value="<?= htmlspecialchars($obat); ?>">

    <label>Nama Obat:</label><br>
    <input type="text" name="obat" value="<?= htmlspecialchars($obat); ?>"><br><br>

    <label>Barcode:</label><br>
    <input type="text" name="kodebar" value="<?= htmlspecialchars($kodebar); ?>"><br><br>

    <label>Kategori:</label><br>
    <input type="radio" name="kategori" value="resep" <?= $kat === 'resep' ? 'checked' : ''; ?>> Dengan Resep Dokter
    <input type="radio" name="kategori" value="bebas" <?= $kat === 'bebas' ? 'checked' : ''; ?>> Tanpa Resep Dokter<br><br>

    <label>Harga Asli Obat:</label><br>
    <input type="number" name="harga_asli" value="<?= htmlspecialchars($asli); ?>"><br><br>

    <label>Harga Jual Obat:</label><br>
    <input type="number" name="harga_jual" value="<?= htmlspecialchars($jual); ?>"><br><br>

    <label>Stok Obat:</label><br>
    <input type="number" name="stok" value="<?= htmlspecialchars($stok); ?>"><br><br>

    <label>Dosis Obat:</label><br>
    <input type="text" name="dosis" value="<?= htmlspecialchars($dosis); ?>"><br><br>

    <label>Keterangan:</label><br>
    <textarea name="ket" rows="5"><?= htmlspecialchars($ket); ?></textarea><br><br>

    <label>Gambar Obat:</label><br>
    <?php if ($gbr): ?>
        <img src="gambar/<?= htmlspecialchars($gbr); ?>" width="150" alt="Preview Gambar"><br><br>
    <?php endif; ?>
    <input type="file" name="gbr_obat" accept="image/*"><br><br>

    <input type="submit" name="update" value="Update Data">
</form>
<?php endif; ?>

<br><br>
<a href="dashboard.php">[Kembali ke Dashboard]</a>
</div>
</body>
</html>
