<?php
session_start();
include 'db.php';

// Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// --- Koneksi ke database ---
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$nama_ps = $kelamin = $umur = $alamat = $no_hape = $ket = "";
$pesan = "";
$hasil_cari = [];

// 🔍 Tahap 1: Cari pasien berdasarkan sebagian nama (tidak case-sensitive)
if (isset($_POST['carinama']) && $_POST['carinama'] !== '' && !isset($_POST['pilih_pasien'])) {
    $cari_nama = trim($_POST['carinama']);
    $like = '%' . strtolower($cari_nama) . '%';

    $stmt = $conn->prepare("SELECT Nama_pasien FROM pasien WHERE LOWER(Nama_pasien) LIKE ?");
    $stmt->bind_param("s", $like);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $hasil_cari[] = $row['Nama_pasien'];
    }

    if (empty($hasil_cari)) {
        $pesan = "<p style='color:red;'>⚠️ Tidak ditemukan pasien yang mengandung kata <b>" . htmlspecialchars($cari_nama) . "</b>.</p>";
    } elseif (count($hasil_cari) === 1) {
        $_POST['pilih_pasien'] = $hasil_cari[0]; // langsung pilih otomatis kalau cuma 1
    } else {
        $pesan = "<p style='color:blue;'>🔎 Ditemukan " . count($hasil_cari) . " pasien yang cocok. Silakan pilih:</p>";
    }

    $stmt->close();
}

// 🔎 Tahap 2: Jika user sudah memilih pasien dari daftar
if (isset($_POST['pilih_pasien'])) {
    $nama_dipilih = $_POST['pilih_pasien'];
    $stmt = $conn->prepare("SELECT Nama_pasien, Kelamin, Umur, Alamat, No_hape, Keterangan 
                            FROM pasien WHERE Nama_pasien = ?");
    $stmt->bind_param("s", $nama_dipilih);
    $stmt->execute();
    $stmt->bind_result($nama_ps, $kelamin, $umur, $alamat, $no_hape, $ket);
    if ($stmt->fetch()) {
        $pesan = "<p style='color:green;'>✅ Data pasien ditemukan: <b>" . htmlspecialchars($nama_ps) . "</b></p>";
    }
    $stmt->close();
}

// 💾 Tahap 3: Jika user mengupdate data pasien
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nama']) && isset($_POST['carinama'])) {
    $nama      = trim($_POST['nama']);
    $kelamin   = trim($_POST['kelamin']);
    $umur      = trim($_POST['umur']);
    $alamat    = trim($_POST['alamat']);
    $no_hape   = trim($_POST['telp']);
    $ket       = trim($_POST['ket']);
    $asal_nama = trim($_POST['carinama']); // nama asli sebelum update

    if ($nama === '' || $kelamin === '' || $umur === '' || $alamat === '' || $no_hape === '') {
        $pesan = "<p style='color:red;'>⚠️ Semua kolom wajib diisi.</p>";
    } else {
        $stmt = $conn->prepare("UPDATE pasien 
                                SET Nama_pasien=?, Kelamin=?, Umur=?, Alamat=?, No_hape=?, Keterangan=? 
                                WHERE LOWER(Nama_pasien) = LOWER(?)");
        $stmt->bind_param("sssssss", $nama, $kelamin, $umur, $alamat, $no_hape, $ket, $asal_nama);

        if ($stmt->execute()) {
            $pesan = "<p style='color:green;'>✅ Update data pasien <b>" . htmlspecialchars($nama) . "</b> berhasil!</p>";
            $nama_ps = $nama;
        } else {
            $pesan = "<p style='color:red;'>❌ Update data pasien gagal!</p>";
        }

        $stmt->close();
    }
}

$conn->close();
?>

<html>
<head>
<title>Edit Data Pasien</title>
<style>
body {
    font-family: Verdana;
    background: #f2f6f9;
    margin: 40px;
}
table {
    background: #ffffff;
    border-radius: 8px;
    padding: 15px;
    box-shadow: 0 0 8px #ccc;
}
input[type=text], textarea, select {
    width: 100%;
    padding: 6px;
    border: 1px solid #aaa;
    border-radius: 4px;
}
input[type=submit] {
    background: #007BFF;
    color: white;
    padding: 10px 25px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}
input[type=submit]:hover {
    background: #0056b3;
}
.message {
    margin-top: 15px;
    font-weight: bold;
}
a {
    text-decoration: none;
    color: #007BFF;
}
a:hover {
    text-decoration: underline;
}
</style>
</head>

<body>
<center>
<font face='verdana' size='6'><b>Edit Data Pasien</b></font><br><br>

<!-- Form pencarian -->
<form method="post">
Masukkan Nama Pasien yang akan diedit:<br>
<input type="text" name="carinama" size="50" 
       value="<?= htmlspecialchars($_POST['carinama'] ?? '') ?>"><br><br>
<input type="submit" value="Cari"><br><br>
</form>

<div class="message"><?= $pesan ?></div>

<!-- Jika ada beberapa hasil -->
<?php if (!empty($hasil_cari) && count($hasil_cari) > 1): ?>
<form method="post">
<input type="hidden" name="carinama" value="<?= htmlspecialchars($_POST['carinama']) ?>">
<table border="0" cellpadding="6" cellspacing="0" width="400" bgcolor="#ffffff">
<?php foreach ($hasil_cari as $nama): ?>
<tr>
<td><button type="submit" name="pilih_pasien" value="<?= htmlspecialchars($nama) ?>" style="width:100%; background:#eee; border:1px solid #ccc; padding:6px; border-radius:4px; cursor:pointer;">
<?= htmlspecialchars($nama) ?>
</button></td>
</tr>
<?php endforeach; ?>
</table>
</form>
<br>
<?php endif; ?>

<!-- Form edit pasien -->
<?php if (!empty($nama_ps)): ?>
<form method="post">
<input type="hidden" name="carinama" value="<?= htmlspecialchars($nama_ps) ?>">

<table border="0" cellpadding="8" cellspacing="0" width="500">
<tr>
<td width="150">Nama:</td>
<td><input type="text" name="nama" value="<?= htmlspecialchars($nama_ps) ?>"></td>
</tr>

<tr>
<td>Kelamin:</td>
<td>
<select name="kelamin">
    <option value="Laki-laki" <?= ($kelamin === 'Laki-laki') ? 'selected' : '' ?>>Laki-laki</option>
    <option value="Perempuan" <?= ($kelamin === 'Perempuan') ? 'selected' : '' ?>>Perempuan</option>
</select>
</td>
</tr>

<tr>
<td>Umur:</td>
<td><input type="text" name="umur" value="<?= htmlspecialchars($umur) ?>"></td>
</tr>

<tr>
<td>Alamat:</td>
<td><input type="text" name="alamat" size="50" value="<?= htmlspecialchars($alamat) ?>"></td>
</tr>

<tr>
<td>No. HP:</td>
<td><input type="text" name="telp" value="<?= htmlspecialchars($no_hape) ?>"></td>
</tr>

<tr>
<td valign="top">Keterangan:</td>
<td><textarea name="ket" cols="50" rows="5"><?= htmlspecialchars($ket) ?></textarea></td>
</tr>
</table>

<br>
<input type="submit" value="Update Data"><br><br>
<a href="dashboard.php">[Kembali]</a><br><br>
</form>
<?php endif; ?>
</center>
</body>
</html>
