<?php
require('fpdf/fpdf.php');
include 'db.php';

// Ambil no_trans dari URL
$no_trans = isset($_GET['no_trans']) ? (int)$_GET['no_trans'] : 0;

// Ambil data transaksi & relasi utama
$stmt = $conn->prepare("
    SELECT 
        t.no_trans, t.Tanggal_beli, t.Total_Biaya, t.Lunas,
        p.Nama AS pelanggan, p.Alamat, p.No_hape,
        k.Merk_kendaraan, k.Plat_nomer, k.Th_pembuatan,
        o.Nama_onderdil, o.Harga_jual
    FROM transaksi t
    JOIN pelanggan p ON t.No_plg = p.no_id
    JOIN kendaraan k ON t.No_kendaraan = k.no_id
    JOIN onderdil o ON t.No_onderdil = o.no_id
    WHERE t.no_trans = ?
");
$stmt->bind_param("i", $no_trans);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$stmt->close();

if (!$data) {
    die("Data transaksi tidak ditemukan.");
}

$status = $data['Lunas'] ? 'LUNAS' : 'BELUM LUNAS';
$profil = $conn->query("SELECT * FROM profil LIMIT 1")->fetch_assoc();

// Ambil biaya service dan biaya lain-lain dari tabel terkait (berdasarkan tanggal transaksi)
$tanggal = $data['Tanggal_beli'];

// Ambil service
$q1 = $conn->prepare("SELECT Biaya_service, Discount FROM service WHERE Tanggal_service = ?");
$q1->bind_param("s", $tanggal);
$q1->execute();
$res1 = $q1->get_result()->fetch_assoc();
$q1->close();

$biaya_service = $res1['Biaya_service'] ?? 0;
$discount_rp    = $res1['Discount'] ?? 0;

// Ambil lain-lain
$q2 = $conn->prepare("SELECT Harga_satuan, Jumlah_beli, Biaya_lain FROM lain_lain WHERE Tanggal_service = ?");
$q2->bind_param("s", $tanggal);
$q2->execute();
$res2 = $q2->get_result()->fetch_assoc();
$q2->close();

$harga_lain  = $res2['Harga_satuan'] ?? 0;
$jumlah_lain = $res2['Jumlah_beli'] ?? 0;
$nama_lain   = $res2['Biaya_lain'] ?? 'Biaya Tambahan';
$total_lain  = $harga_lain * $jumlah_lain;

// Buat PDF
$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();

// Header Bengkel
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(190, 10, strtoupper($profil['Nama_bengkel']), 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(190, 6, $profil['Alamat'], 0, 1, 'C');
$pdf->Cell(190, 6, 'Telp: '.$profil['No_hape'].' | Email: '.$profil['Email'], 0, 1, 'C');
$pdf->Ln(8);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(190, 8, 'NOTA TRANSAKSI', 0, 1, 'C');
$pdf->Ln(5);

// Info Umum
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(40, 6, 'No Transaksi', 0, 0); $pdf->Cell(80, 6, ': '.$data['no_trans'], 0, 1);
$pdf->Cell(40, 6, 'Tanggal', 0, 0); $pdf->Cell(80, 6, ': '.$data['Tanggal_beli'], 0, 1);
$pdf->Cell(40, 6, 'Status', 0, 0); $pdf->Cell(80, 6, ': '.$status, 0, 1);
$pdf->Ln(5);

// Data Pelanggan
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(190, 7, 'Data Pelanggan', 0, 1);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(40, 6, 'Nama', 0, 0); $pdf->Cell(80, 6, ': '.$data['pelanggan'], 0, 1);
$pdf->Cell(40, 6, 'Alamat', 0, 0); $pdf->Cell(80, 6, ': '.$data['Alamat'], 0, 1);
$pdf->Cell(40, 6, 'No. HP', 0, 0); $pdf->Cell(80, 6, ': '.$data['No_hape'], 0, 1);
$pdf->Ln(5);

// Data Kendaraan
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(190, 7, 'Data Kendaraan', 0, 1);
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(40, 6, 'Merk/Tipe', 0, 0); $pdf->Cell(80, 6, ': '.$data['Merk_kendaraan'], 0, 1);
$pdf->Cell(40, 6, 'Plat Nomer', 0, 0); $pdf->Cell(80, 6, ': '.$data['Plat_nomer'], 0, 1);
$pdf->Cell(40, 6, 'Tahun', 0, 0); $pdf->Cell(80, 6, ': '.$data['Th_pembuatan'], 0, 1);
$pdf->Ln(5);

// Tabel Onderdil
$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(190, 7, 'Rincian Pembelian & Servis', 0, 1);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(10, 8, 'No', 1, 0, 'C');
$pdf->Cell(90, 8, 'Keterangan', 1, 0, 'C');
$pdf->Cell(40, 8, 'Harga (Rp)', 1, 0, 'C');
$pdf->Cell(50, 8, 'Total (Rp)', 1, 1, 'C');

$pdf->SetFont('Arial', '', 10);
$no = 1;

// Baris onderdil
$pdf->Cell(10, 8, $no++, 1, 0, 'C');
$pdf->Cell(90, 8, $data['Nama_onderdil'], 1, 0);
$pdf->Cell(40, 8, number_format($data['Harga_jual'], 0, ',', '.'), 1, 0, 'R');
$pdf->Cell(50, 8, number_format($data['Harga_jual'], 0, ',', '.'), 1, 1, 'R');

// Baris service
if ($biaya_service > 0) {
    $pdf->Cell(10, 8, $no++, 1, 0, 'C');
    $pdf->Cell(90, 8, 'Biaya Service', 1, 0);
    $pdf->Cell(40, 8, number_format($biaya_service, 0, ',', '.'), 1, 0, 'R');
    $pdf->Cell(50, 8, number_format($biaya_service, 0, ',', '.'), 1, 1, 'R');
}

// Baris lain-lain
if ($harga_lain > 0) {
    $pdf->Cell(10, 8, $no++, 1, 0, 'C');
    $pdf->Cell(90, 8, $nama_lain, 1, 0);
    $pdf->Cell(40, 8, number_format($harga_lain, 0, ',', '.').' x '.$jumlah_lain, 1, 0, 'R');
    $pdf->Cell(50, 8, number_format($total_lain, 0, ',', '.'), 1, 1, 'R');
}

// Diskon
if ($discount_rp > 0) {
    $pdf->Cell(140, 8, 'DISKON', 1, 0, 'R');
    $pdf->Cell(50, 8, '- Rp '.number_format($discount_rp, 0, ',', '.'), 1, 1, 'R');
}

// Total akhir
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(140, 8, 'TOTAL BIAYA AKHIR', 1, 0, 'R');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(50, 8, 'Rp '.number_format($data['Total_Biaya'], 0, ',', '.'), 1, 1, 'R');

$pdf->Ln(8);
$pdf->SetFont('Arial', 'I', 9);
$pdf->Cell(190, 6, 'Terima kasih atas kepercayaan Anda.', 0, 1, 'C');
$pdf->Cell(190, 6, 'Harap simpan nota ini sebagai bukti transaksi resmi.', 0, 1, 'C');

$pdf->Output('I', 'Invoice_'.$data['no_trans'].'.pdf');
?>
