<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Bengkel</title>
<style>
   body {
      font-family: Arial, sans-serif;
      background: linear-gradient(to bottom right, #1e3c72, #2a5298);
      color: #fff;
      text-align: center;
      margin: 0;
      padding: 0;
   }
   .container {
      background: rgba(255,255,255,0.1);
      padding: 30px;
      border-radius: 15px;
      display: inline-block;
      margin-top: 60px;
      box-shadow: 0 0 15px rgba(0,0,0,0.3);
   }
   h1 {
      margin-bottom: 10px;
      font-size: 28px;
      color: #ffeb3b;
   }
   a {
      display: block;
      color: #fff;
      text-decoration: none;
      background: rgba(0,0,0,0.2);
      margin: 8px auto;
      width: 280px;
      padding: 10px;
      border-radius: 8px;
      transition: all 0.3s;
   }
   a:hover {
      background: #ffeb3b;
      color: #000;
      font-weight: bold;
      transform: scale(1.05);
   }
   .logout {
      background: #d32f2f;
      color: #fff;
      font-weight: bold;
   }
   .logout:hover {
      background: #ff5252;
      color: #000;
   }
</style>
</head>

<body>
   <div class="container">
      <h1>Selamat Datang, <?= htmlspecialchars($_SESSION['username']) ?></h1>
      <br>

      <a href="logout.php" class="logout">Logout</a>

      <a href="setup.php">Setup Profil Bengkel</a>
      <a href="register.php">Pendaftaran Operator Baru (Only Boss)</a>
      <a href="lihat_operator.php">Daftar Operator (Only Boss)</a>
      <a href="isi_onderdil.php">Tambah Spare Part Baru</a>
      <a href="edit_onderdil.php">Edit & Hapus Data Spare Part</a>
      <a href="lihat_onderdil.php">Lihat Semua Onderdil</a>
      <a href="isi_pelanggan.php">Pendaftaran Pelanggan</a>
      <a href="edit_pelanggan.php">Edit Pelanggan</a>
      <a href="hapus_pelanggan.php">Hapus Pelanggan</a>
      <a href="lihat_pelanggan.php">Lihat Semua Pelanggan</a>
      <a href="tambah_kendaraan.php">Manajemen Data Kendaraan</a>
      <a href="transaksi.php">Transaksi</a>
   </div>
</body>
</html>
