<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header('Location: index.php');
    exit;
}

if (!isset($_GET['no_id'])) {
    header('Location: tambah_kendaraan.php');
    exit;
}

$id = (int) $_GET['no_id'];
$message = "";

// Ambil data lama
$stmt = $conn->prepare("SELECT Merk_kendaraan, Tipe_kendaraan, Plat_nomer, Th_pembuatan, Keterangan 
                        FROM kendaraan WHERE no_id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($merk, $tipe, $plat, $tahun, $ket);
$stmt->fetch();
$stmt->close();

// Update jika form dikirim
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $merk_baru  = trim($_POST['merk']);
    $tipe_baru  = trim($_POST['tipe']);
    $plat_baru  = trim($_POST['plat']);
    $tahun_baru = trim($_POST['tahun']);
    $ket_baru   = trim($_POST['ket']);

    $stmt = $conn->prepare("UPDATE kendaraan 
                            SET Merk_kendaraan=?, Tipe_kendaraan=?, Plat_nomer=?, Th_pembuatan=?, Keterangan=? 
                            WHERE no_id=?");
    $stmt->bind_param("sssssi", $merk_baru, $tipe_baru, $plat_baru, $tahun_baru, $ket_baru, $id);

    if ($stmt->execute()) {
        echo "<script>alert('✅ Data kendaraan berhasil diperbarui!'); window.location='tambah_kendaraan.php';</script>";
    } else {
        $message = "<font color=red>❌ Gagal memperbarui data!</font>";
    }
    $stmt->close();
}
$conn->close();
?>

<html>
<head>
<title>Edit Kendaraan</title>
<style>
body {
    font-family: Verdana;
    background: linear-gradient(to bottom right, #f0f7ff, #dce5ff);
}
form {
    background: #ffffff;
    width: 500px;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
}
input[type=text], textarea {
    width: 100%;
    padding: 8px;
    border-radius: 6px;
    border: 1px solid #aaa;
}
input[type=submit] {
    background: #28a745;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 8px;
    cursor: pointer;
}
input[type=submit]:hover {
    background: #218838;
}
a {
    text-decoration: none;
    color: #0078D7;
}
a:hover {
    color: #005fa3;
}
</style>
</head>

<body>
<center>
    <form method="post">
        <h2>✏️ Edit Data Kendaraan</h2>

        <label>Merk Kendaraan:</label><br>
        <input type="text" name="merk" value="<?= htmlspecialchars($merk) ?>"><br><br>

        <label>Tipe Kendaraan:</label><br>
        <input type="text" name="tipe" value="<?= htmlspecialchars($tipe) ?>"><br><br>

        <label>Plat Nomor:</label><br>
        <input type="text" name="plat" value="<?= htmlspecialchars($plat) ?>"><br><br>

        <label>Tahun Pembuatan:</label><br>
        <input type="text" name="tahun" value="<?= htmlspecialchars($tahun) ?>"><br><br>

        <label>Keterangan:</label><br>
        <textarea name="ket" rows="4"><?= htmlspecialchars($ket) ?></textarea><br><br>

        <input type="submit" value="💾 Update Data"><br><br>
        <?= $message ?><br><br>
        <a href="tambah_kendaraan.php">← Kembali ke Daftar</a>
    </form>
</center>
</body>
</html>
