<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

$msg = "";
$hasil = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

   // --- PENCARIAN ---
   if (isset($_POST['search'])) {
      $cari = trim($_POST['cari']);
      $stmt = $conn->prepare("SELECT Nama, Alamat, Email, No_hape 
                              FROM pelanggan 
                              WHERE LOWER(Nama) LIKE LOWER(?)");
      $like = "%$cari%";
      $stmt->bind_param("s", $like);
      $stmt->execute();
      $result = $stmt->get_result();
      while ($row = $result->fetch_assoc()) {
         $hasil[] = $row;
      }
      if (empty($hasil)) {
         $msg = "<font color='red'>Tidak ditemukan pelanggan dengan kata '$cari'.</font>";
      }
      $stmt->close();
   }

   // --- UPDATE ---
   if (isset($_POST['update'])) {
      $nama_lama = trim($_POST['nama_lama']);
      $nama   = trim($_POST['nama']);
      $alamat = trim($_POST['alamat']);
      $email  = trim($_POST['email']);
      $telp   = trim($_POST['telp']);

      $stmt = $conn->prepare("UPDATE pelanggan 
                              SET Nama=?, Alamat=?, Email=?, No_hape=? 
                              WHERE Nama=?");
      $stmt->bind_param("sssss", $nama, $alamat, $email, $telp, $nama_lama);

      if ($stmt->execute()) {
         $msg = "<font color='green'>Data '$nama_lama' berhasil diperbarui!</font>";
      } else {
         $msg = "<font color='red'>Gagal memperbarui data '$nama_lama'.</font>";
      }
      $stmt->close();
   }

   $conn->close();
}
?>

<html>
<head>
<title>Edit Data Pelanggan</title>
<style>
body {
   font-family: Verdana;
   background: #f0f8ff;
}
.container {
   width: 800px;
   margin: 50px auto;
   background: #ffffff;
   padding: 30px;
   border-radius: 15px;
   box-shadow: 0 0 10px rgba(0,0,0,0.2);
   text-align: center;
}
input[type=text] {
   width: 90%;
   padding: 8px;
   margin: 5px 0;
   border: 1px solid #ccc;
   border-radius: 5px;
}
input[type=submit] {
   background-color: #4CAF50;
   color: white;
   border: none;
   padding: 8px 15px;
   border-radius: 8px;
   cursor: pointer;
   font-weight: bold;
}
input[type=submit]:hover {
   background-color: #45a049;
}
.card {
   background: #fafafa;
   padding: 15px;
   margin: 15px 0;
   border-radius: 10px;
   box-shadow: 0 0 5px rgba(0,0,0,0.1);
   text-align: left;
}
a {
   text-decoration: none;
   color: #0066cc;
}
</style>
</head>

<body>
<div class="container">
   <h2>Edit Data Pelanggan</h2>
   <?= $msg ?><br>

   <form method="post">
      <b>Cari pelanggan (boleh sebagian kata, tidak peka huruf besar kecil):</b><br>
      <input type="text" name="cari" placeholder="contoh: ani, joko, fitri..." required>
      <input type="submit" name="search" value="Cari">
   </form>

   <?php if (!empty($hasil)): ?>
      <hr>
      <?php foreach ($hasil as $row): ?>
         <div class="card">
            <form method="post">
               <input type="hidden" name="nama_lama" value="<?= htmlspecialchars($row['Nama']) ?>">
               <b>Nama:</b><br>
               <input type="text" name="nama" value="<?= htmlspecialchars($row['Nama']) ?>"><br>
               <b>Alamat:</b><br>
               <input type="text" name="alamat" value="<?= htmlspecialchars($row['Alamat']) ?>"><br>
               <b>Email:</b><br>
               <input type="text" name="email" value="<?= htmlspecialchars($row['Email']) ?>"><br>
               <b>No. Hape:</b><br>
               <input type="text" name="telp" value="<?= htmlspecialchars($row['No_hape']) ?>"><br><br>
               <center><input type="submit" name="update" value="Update Data Ini"></center>
            </form>
         </div>
      <?php endforeach; ?>
   <?php endif; ?>

   <br><br>
   <a href="dashboard.php">[Kembali ke Dashboard]</a>
</div>
</body>
</html>
