<?php
session_start();
include 'db.php';

// --- Cek Login ---
if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

// --- Proses Form ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $nama = trim($_POST['nama']);
   $beli = (int) $_POST['beli'];
   $jual = (int) $_POST['jual'];
   $stok = (int) $_POST['stok'];

   $stmt = $conn->prepare("INSERT INTO onderdil (Nama_onderdil, Harga_beli, Harga_jual, Stok) VALUES (?, ?, ?, ?)");
   $stmt->bind_param("siii", $nama, $beli, $jual, $stok);

   if ($stmt->execute()) {
      $pesan = "<font color=green><b>✅ Data spare part berhasil ditambahkan!</b></font>";
   } else {
      $pesan = "<font color=red><b>❌ Data spare part gagal ditambahkan!</b></font>";
   }

   $stmt->close();
   $conn->close();
}
?>

<html>
<head>
<title>Tambah Data Spare Part</title>
<style>
body {
   font-family: Verdana;
   background: linear-gradient(135deg, #e0e0e0, #fefefe);
}
form {
   background: white;
   padding: 25px;
   border-radius: 12px;
   box-shadow: 0 0 10px rgba(0,0,0,0.2);
   width: 350px;
}
input[type=text], input[type=number] {
   width: 90%;
   padding: 8px;
   border-radius: 5px;
   border: 1px solid #aaa;
}
input[type=submit] {
   background: #0066cc;
   color: white;
   border: none;
   padding: 10px 25px;
   border-radius: 8px;
   cursor: pointer;
}
input[type=submit]:hover {
   background: #004a99;
}
a {
   color: #3333cc;
   text-decoration: none;
}
a:hover {
   text-decoration: underline;
}
</style>
</head>

<body>
<center>
   <h2>🛠️ Tambah Data Spare Part</h2>
   <?php if (!empty($pesan)) echo $pesan . "<br><br>"; ?>
   <form method="post">
      <label>Nama Spare Part:</label><br>
      <input type="text" name="nama" required><br><br>

      <label>Harga Beli:</label><br>
      <input type="number" name="beli" required><br><br>

      <label>Harga Jual:</label><br>
      <input type="number" name="jual" required><br><br>

      <label>Stok:</label><br>
      <input type="number" name="stok" required><br><br>

      <input type="submit" value="Tambah"><br><br>
   </form>
   <a href="dashboard.php">⬅️ Kembali ke Dashboard</a>
</center>
</body>
</html>
