<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

$result = $conn->query("SELECT * FROM onderdil");
?>

<html>
<head>
<title>Daftar Onderdil</title>
<style>
body {
  font-family: "Segoe UI", Verdana, sans-serif;
  background: linear-gradient(to bottom right, #e6f0ff, #ffffff);
  margin: 0;
  padding: 0;
}
.container {
  width: 90%;
  margin: 40px auto;
  background: #fff;
  border-radius: 10px;
  box-shadow: 0 0 12px rgba(0,0,0,0.1);
  padding: 20px;
}
h2 {
  text-align: center;
  color: #004085;
}
table {
  border-collapse: collapse;
  width: 100%;
  margin-top: 20px;
}
th, td {
  padding: 10px;
  text-align: center;
}
th {
  background-color: #007bff;
  color: white;
}
tr:nth-child(even) {
  background-color: #f2f6ff;
}
tr:hover {
  background-color: #e0ebff;
}
a.button {
  text-decoration: none;
  color: white;
  padding: 8px 14px;
  border-radius: 6px;
  font-size: 14px;
  margin: 5px;
  display: inline-block;
}
a.edit {
  background-color: #28a745;
}
a.delete {
  background-color: #dc3545;
}
a.export {
  background-color: #17a2b8;
}
a.add {
  background-color: #007bff;
}
a.logout {
  background-color: #6c757d;
}
a.edit:hover { background-color: #218838; }
a.delete:hover { background-color: #c82333; }
a.export:hover { background-color: #138496; }
a.add:hover { background-color: #0056b3; }
a.logout:hover { background-color: #5a6268; }

.button-bar {
  text-align: center;
  margin-bottom: 20px;
}
</style>
</head>

<body>
<div class="container">
  <h2>📦 Daftar Onderdil</h2>

  <div class="button-bar">
    <a href="isi_onderdil.php" class="button add">➕ Tambah Onderdil</a>
    <a href="onderdil_export_excel.php" class="button export">📤 Export Excel</a>
    <a href="dashboard.php" class="button logout">🚪 Kembali</a>
  </div>

  <table border="1">
    <tr>
      <th>Nama Onderdil</th>
      <th>Harga Beli</th>
      <th>Harga Jual</th>
      <th>Stok</th>
      <th>Aksi</th>
    </tr>

    <?php
    while ($row = $result->fetch_assoc()) {
      $nama = htmlspecialchars($row['Nama_onderdil']);
      echo "<tr>";
      echo "<td>$nama</td>";
      echo "<td>" . number_format($row['Harga_beli'], 0, ',', '.') . "</td>";
      echo "<td>" . number_format($row['Harga_jual'], 0, ',', '.') . "</td>";
      echo "<td>" . htmlspecialchars($row['Stok']) . "</td>";
      echo "<td>
              <a href='edit_onderdil.php?nama=$nama' class='button edit'>✏️ Edit</a>
              <a href='hapus_onderdil.php?nama=$nama' class='button delete' onclick='return confirm(\"Yakin ingin menghapus $nama?\")'>🗑️ Hapus</a>
            </td>";
      echo "</tr>";
    }
    $conn->close();
    ?>
  </table>
</div>
</body>
</html>
