<?php
session_start();
include 'db.php';

// 🔒 Hanya 'boss' yang boleh mengakses
if ($_SESSION['username'] !== 'boss') {
    header("Location: index.php");
    exit;
}

// === Hapus operator jika tombol ditekan ===
if (isset($_GET['hapus'])) {
    $user_hapus = $_GET['hapus'];

    // Hindari penghapusan akun boss sendiri
    if ($user_hapus === 'boss') {
        echo "<script>alert('Akun boss tidak boleh dihapus!');</script>";
    } else {
        $stmt = $conn->prepare("DELETE FROM users WHERE username = ?");
        $stmt->bind_param("s", $user_hapus);
        if ($stmt->execute()) {
            echo "<script>alert('Operator berhasil dihapus!'); window.location='lihat_operator.php';</script>";
        } else {
            echo "<script>alert('Gagal menghapus operator!');</script>";
        }
        $stmt->close();
    }
}

// === Ambil semua operator dari tabel ===
$result = $conn->query("SELECT username FROM users ORDER BY username ASC");

if (!$result) {
    die("Query gagal: " . htmlspecialchars($conn->error));
}

// === Tampilkan tabel ===
echo "<center>";
echo "<h2>Daftar Operator</h2>";
echo "<table border='0' cellpadding='8' cellspacing='1' bgcolor='#000000'>
<tr bgcolor='#ffcc00'>
<td><b>Username</b></td>
<td><b>Aksi</b></td>
</tr>";

while ($row = $result->fetch_assoc()) {
    $username = htmlspecialchars($row['username']);
    echo "<tr bgcolor='#ffffff'>";
    echo "<td>" . $username . "</td>";
    echo "<td align='center'>
            <a href='?hapus={$username}' 
               onclick='return confirm(\"Yakin hapus operator: {$username} ?\")'>
               ❌ Hapus
            </a>
          </td>";
    echo "</tr>";
}

echo "</table>";
echo "<br><a href='dashboard.php'>⬅️ Kembali ke Dashboard</a>";
echo "</center>";

$result->free();
$conn->close();
?>
