<?php
session_start();
include 'db.php';

// --- Cek login ---
if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

// Ambil data profil lama (jika ada)
$stmt = $conn->prepare("SELECT Nama_bengkel, Alamat, Email, No_hape, Gbr_bengkel FROM profil LIMIT 1");
$stmt->execute();
$stmt->bind_result($nama_bengkel, $alamat, $email, $no_hape, $logo);
$stmt->fetch();
$stmt->close();

// --- Proses form ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $nama   = trim($_POST['nama']);
   $alamat = trim($_POST['alamat']);
   $email  = trim($_POST['email']);
   $telp   = trim($_POST['telp']);

   $target_dir = "gambar/";
   if (!is_dir($target_dir)) mkdir($target_dir, 0755, true);

   $nama_file = basename($_FILES["gbr"]["name"]);
   $target_file = $target_dir . $nama_file;
   $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
   $uploadOk = 1;

   if (!empty($_FILES["gbr"]["tmp_name"])) {
       $check = getimagesize($_FILES["gbr"]["tmp_name"]);
       if ($check === false) {
           echo "<div class='msg error'>File bukan gambar!</div>";
           $uploadOk = 0;
       }
       if ($_FILES["gbr"]["size"] > 5000000) {
           echo "<div class='msg error'>Ukuran file terlalu besar (max 5MB)!</div>";
           $uploadOk = 0;
       }
       if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
           echo "<div class='msg error'>Format tidak diizinkan (hanya JPG, PNG, GIF)!</div>";
           $uploadOk = 0;
       }

       if ($uploadOk == 1) {
           if (move_uploaded_file($_FILES["gbr"]["tmp_name"], $target_file)) {
               $logo = $nama_file;
           } else {
               echo "<div class='msg error'>Gagal mengupload gambar.</div>";
           }
       }
   }

   // Simpan ke database
   $stmt = $conn->prepare("UPDATE profil SET Nama_bengkel=?, Alamat=?, Email=?, No_hape=?, Gbr_bengkel=?");
   $stmt->bind_param("sssss", $nama, $alamat, $email, $telp, $logo);
   if ($stmt->execute()) {
       echo "<div class='msg success'>Profil Bengkel berhasil diupdate!</div>";
       $nama_bengkel = $nama;
       $alamat = $alamat;
       $email = $email;
       $no_hape = $telp;
   } else {
       echo "<div class='msg error'>Gagal update profil.</div>";
   }
   $stmt->close();
}

$conn->close();
?>

<html>
<head>
<title>Setup Profil Bengkel</title>
<style>
body {
   font-family: Arial, sans-serif;
   background: linear-gradient(135deg, #d9e7ff, #ffffff);
   margin: 0;
   padding: 0;
}
.container {
   max-width: 500px;
   margin: 60px auto;
   background: #ffffff;
   padding: 25px 30px;
   border-radius: 15px;
   box-shadow: 0 0 15px rgba(0,0,0,0.2);
}
h2 {
   text-align: center;
   color: #004aad;
}
label {
   font-weight: bold;
   color: #333;
}
input[type=text], input[type=email], input[type=file] {
   width: 100%;
   padding: 8px;
   margin-top: 5px;
   margin-bottom: 15px;
   border: 1px solid #ccc;
   border-radius: 5px;
   box-sizing: border-box;
}
input[type=submit] {
   background: #004aad;
   color: white;
   border: none;
   padding: 10px 20px;
   border-radius: 5px;
   cursor: pointer;
   width: 100%;
   font-size: 16px;
   transition: 0.3s;
}
input[type=submit]:hover {
   background: #0078ff;
}
.msg {
   text-align: center;
   margin-bottom: 10px;
   padding: 10px;
   border-radius: 5px;
}
.msg.success {
   background: #e7ffe7;
   color: #008000;
}
.msg.error {
   background: #ffe7e7;
   color: #cc0000;
}
.logo-preview {
   display: block;
   margin: 15px auto;
   border-radius: 10px;
   max-width: 200px;
   box-shadow: 0 0 8px rgba(0,0,0,0.1);
}
a {
   display: block;
   text-align: center;
   margin-top: 20px;
   color: #004aad;
   text-decoration: none;
}
a:hover {
   text-decoration: underline;
}
</style>
</head>

<body>
<div class="container">
   <h2>Setup Profil Bengkel</h2>
   <form method="post" enctype="multipart/form-data">
      <label>Nama Bengkel:</label>
      <input type="text" name="nama" value="<?= htmlspecialchars($nama_bengkel) ?>" required>

      <label>Alamat:</label>
      <input type="text" name="alamat" value="<?= htmlspecialchars($alamat) ?>" required>

      <label>Email:</label>
      <input type="email" name="email" value="<?= htmlspecialchars($email) ?>" required>

      <label>No. Hape:</label>
      <input type="text" name="telp" value="<?= htmlspecialchars($no_hape) ?>" required>

      <label>Logo Bengkel:</label>
      <input type="file" name="gbr" accept="image/*">

      <?php if (!empty($logo)) : ?>
         <img src="gambar/<?= htmlspecialchars($logo) ?>" alt="Logo Bengkel" class="logo-preview">
      <?php endif; ?>

      <input type="submit" value="Update Profil">
   </form>
   <a href="dashboard.php">⬅️ Kembali ke Dashboard</a>
</div>
</body>
</html>
