<?php


ini_set('display_errors', 1);
error_reporting(E_ALL);


session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header('Location: index.php');
    exit;
}

$message = "";
$keyword = "";

// === SIMPAN DATA ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['simpan'])) {
    $merk  = trim($_POST['merk']);
    $tipe  = trim($_POST['tipe']);
    $plat  = trim($_POST['plat']);
    $tahun = trim($_POST['tahun']);
    $ket   = trim($_POST['ket']);

    if ($merk === "" || $tipe === "" || $plat === "" || $tahun === "") {
        $message = "<font color=red>⚠️ Semua kolom wajib diisi!</font>";
    } else {
        $stmt = $conn->prepare("INSERT INTO kendaraan 
            (Merk_kendaraan, Tipe_kendaraan, Plat_nomer, Th_pembuatan, Keterangan) 
            VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $merk, $tipe, $plat, $tahun, $ket);

        if ($stmt->execute()) {
            $message = "<font color=green>✅ Data kendaraan berhasil disimpan!</font>";
        } else {
            $message = "<font color=red>❌ Data kendaraan gagal disimpan.</font>";
        }
        $stmt->close();
    }
}

// === EXPORT KE EXCEL ===
if (isset($_POST['export_excel'])) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=data_kendaraan.xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    echo "No\tMerk\tTipe\tPlat Nomor\tTahun\tKeterangan\n";
    $no = 1;
    $result = $conn->query("SELECT * FROM kendaraan ORDER BY no_id DESC");
    while ($row = $result->fetch_assoc()) {
        echo $no++ . "\t" .
             $row['Merk_kendaraan'] . "\t" .
             $row['Tipe_kendaraan'] . "\t" .
             $row['Plat_nomer'] . "\t" .
             $row['Th_pembuatan'] . "\t" .
             $row['Keterangan'] . "\n";
    }
    exit;
}

// === PENCARIAN ===
if (isset($_POST['cari'])) {
    $keyword = trim($_POST['keyword']);
    $kata = "%$keyword%";
    $stmt = $conn->prepare("SELECT * FROM kendaraan 
        WHERE LOWER(Merk_kendaraan) LIKE LOWER(?) 
        OR LOWER(Tipe_kendaraan) LIKE LOWER(?) 
        OR LOWER(Plat_nomer) LIKE LOWER(?)
        ORDER BY no_id DESC");
    $stmt->bind_param("sss", $kata, $kata, $kata);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query("SELECT * FROM kendaraan ORDER BY no_id DESC");
}
?>
<html>
<head>
<title>Manajemen Kendaraan</title>
<style>
body {
    font-family: Verdana;
    background: linear-gradient(to bottom right, #f0f7ff, #dce5ff);
}
form {
    background: #ffffff;
    width: 500px;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 10px rgba(0,0,0,0.2);
    margin-bottom: 40px;
}
input[type=text], textarea {
    width: 100%;
    padding: 8px;
    border-radius: 6px;
    border: 1px solid #aaa;
}
input[type=submit], button {
    background: #0078D7;
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 14px;
}
input[type=submit]:hover, button:hover {
    background: #005fa3;
}
a {
    text-decoration: none;
    color: #0078D7;
}
a:hover {
    color: #005fa3;
}
table {
    border-collapse: collapse;
    width: 90%;
    background: white;
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}
th {
    background: #0078D7;
    color: white;
    padding: 10px;
}
td {
    padding: 8px;
    border: 1px solid #ddd;
}
tr:hover {
    background: #f5f5f5;
}
.btnhapus {
    color: white;
    background: red;
    padding: 5px 10px;
    border-radius: 6px;
    text-decoration: none;
}
.btnedit {
    color: white;
    background: green;
    padding: 5px 10px;
    border-radius: 6px;
    text-decoration: none;
}
.cari-box {
    margin-bottom: 15px;
}
</style>
</head>

<body>
<center>
    <form method="post">
        <h2>🚗 Tambah Data Kendaraan</h2>

        <label>Merk Kendaraan:</label><br>
        <input type="text" name="merk"><br><br>

        <label>Tipe Kendaraan:</label><br>
        <input type="text" name="tipe"><br><br>

        <label>Plat Nomor:</label><br>
        <input type="text" name="plat"><br><br>

        <label>Tahun Pembuatan:</label><br>
        <input type="text" name="tahun"><br><br>

        <label>Keterangan:</label><br>
        <textarea name="ket" rows="4"></textarea><br><br>

        <input type="submit" name="simpan" value="💾 Simpan Data"><br><br>
        <?= $message ?><br><br>
        <a href="dashboard.php">← Kembali ke Dashboard</a>
    </form>

    <h2>📋 Daftar Kendaraan</h2>

    <!-- Form pencarian -->
    <form method="post" class="cari-box">
        <input type="text" name="keyword" placeholder="🔍 Cari merk, tipe, atau plat..." value="<?= htmlspecialchars($keyword) ?>" style="width:300px; padding:6px;">
        <input type="submit" name="cari" value="Cari"><br><br>
        <input type="submit" name="export_excel" value="📊 Export ke Excel">
    </form>

    <table>
        <tr>
            <th>No</th>
            <th>Merk</th>
            <th>Tipe</th>
            <th>Plat Nomor</th>
            <th>Tahun</th>
            <th>Keterangan</th>
            <th>Aksi</th>
        </tr>
        <?php
        $no = 1;
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo "<tr>";
                echo "<td align=center>" . $no++ . "</td>";
                echo "<td>" . htmlspecialchars($row['Merk_kendaraan']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Tipe_kendaraan']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Plat_nomer']) . "</td>";
                echo "<td align=center>" . htmlspecialchars($row['Th_pembuatan']) . "</td>";
                echo "<td>" . htmlspecialchars($row['Keterangan']) . "</td>";
                echo "<td align=center>
                        <a href='edit_kendaraan.php?no_id=" . $row['no_id'] . "' class='btnedit'>Edit</a> 
                        <a href='hapus_kendaraan.php?no_id=" . $row['no_id'] . "' class='btnhapus' onclick=\"return confirm('Hapus data ini?')\">Hapus</a>
                      </td>";
                echo "</tr>";
            }
        } else {
            echo "<tr><td colspan=7 align=center><i>Tidak ada data ditemukan</i></td></tr>";
        }
        ?>
    </table>
</center>
</body>
</html>
