<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Toko</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background: linear-gradient(135deg, #f0f0f0, #d9e4f5);
    color: #333;
    margin: 0;
    padding: 0;
}
.container {
    width: 420px;
    margin: 80px auto;
    background: #fff;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    text-align: center;
}
h2 {
    color: #0066cc;
    margin-bottom: 20px;
}
a {
    display: block;
    margin: 8px 0;
    padding: 10px;
    background: #f5f5f5;
    border-radius: 8px;
    text-decoration: none;
    color: #333;
    transition: all 0.3s ease;
}
a:hover {
    background: #0066cc;
    color: #fff;
}
a.logout {
    background: #cc0000;
    color: #fff;
}
a.logout:hover {
    background: #ff4444;
}
.only-boss {
    color: #cc0000;
    font-weight: bold;
}
</style>
</head>

<body>
<div class="container">
    <h2>Selamat Datang, <?= htmlspecialchars($_SESSION['username']) ?></h2>

    <a href="logout.php" class="logout">Logout</a>
    <a href="setup.php">⚙️ Setup Toko</a>
    <a href="register.php" class="only-boss">🧑‍💼 Pendaftaran Operator (Only Boss)</a>
    <a href="daftar_operator.php" class="only-boss">🗑️ Hapus Operator (Only Boss)</a>
    <a href="ganti_sandi.php">🔐 Ganti Password Operator</a>
    <a href="tambah_barang.php">➕ Tambah Barang Baru</a>
    <a href="transaksi.php">🛒 Melakukan Transaksi</a>
    <a href="keuntungan.php">💰 Lihat Keuntungan</a>
    <a href="kadaluwarsa.php">⏳ Barang Kadaluwarsa</a>
    <a href="kosong_transaksi.php" class="only-boss">🚫 Hapus Semua Data Transaksi (Only Boss)</a>
</div>
</body>
</html>
