<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

$pesan = "";
$warna = "black";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $user_login  = $_SESSION['username'];
   $sandilama   = trim($_POST['sandilama']);
   $sandibaru1  = trim($_POST['sandibaru1']);
   $sandibaru2  = trim($_POST['sandibaru2']);

   // Ambil hash password lama
   $stmt = $conn->prepare("SELECT password FROM operator WHERE username = ?");
   $stmt->bind_param("s", $user_login);
   $stmt->execute();
   $stmt->bind_result($hash_lama);
   $stmt->fetch();
   $stmt->close();

   if (!$hash_lama) {
       $pesan = "User tidak ditemukan!";
       $warna = "red";
   } elseif (!password_verify($sandilama, $hash_lama)) {
       $pesan = "Password lama tidak cocok!";
       $warna = "red";
   } elseif ($sandibaru1 !== $sandibaru2) {
       $pesan = "Password baru tidak sama, ulangi!";
       $warna = "red";
   } else {
       $hashed = password_hash($sandibaru1, PASSWORD_DEFAULT);
       $stmt = $conn->prepare("UPDATE operator SET password = ? WHERE username = ?");
       $stmt->bind_param("ss", $hashed, $user_login);
       if ($stmt->execute()) {
           $pesan = "✅ Password berhasil diperbarui!";
           $warna = "green";
       } else {
           $pesan = "❌ Gagal memperbarui password!";
           $warna = "red";
       }
       $stmt->close();
   }
}

$conn->close();
?>

<html>
<head>
<title>Ganti Password Operator</title>
<style>
body {
   font-family: Verdana;
   background-color: #f0f0f0;
   color: #333;
}
.container {
   background: white;
   border-radius: 10px;
   box-shadow: 0 0 10px rgba(0,0,0,0.2);
   width: 480px;
   margin: 80px auto;
   padding: 30px;
   text-align: center;
}
input[type=password] {
   width: 90%;
   padding: 10px;
   margin-top: 5px;
   border: 1px solid #ccc;
   border-radius: 5px;
   font-size: 14px;
}
input[type=submit] {
   background-color: #007bff;
   color: white;
   padding: 10px 20px;
   border: none;
   border-radius: 5px;
   font-size: 14px;
   cursor: pointer;
   margin-top: 15px;
}
input[type=submit]:hover {
   background-color: #0056b3;
}
.pesan {
   font-size: 14px;
   margin-top: 20px;
}
.button-back {
   display: inline-block;
   margin-top: 20px;
   background-color: #28a745;
   color: white;
   text-decoration: none;
   padding: 8px 16px;
   border-radius: 5px;
}
.button-back:hover {
   background-color: #218838;
}
</style>
</head>

<body>
<div class="container">
<h2>🔐 Ganti Password Operator</h2>
<form method="post">
   <label>Password Lama:</label><br>
   <input type="password" name="sandilama" required><br><br>

   <label>Password Baru:</label><br>
   <input type="password" name="sandibaru1" required><br><br>

   <label>Ulangi Password Baru:</label><br>
   <input type="password" name="sandibaru2" required><br><br>

   <input type="submit" value="Ganti Password">
</form>

<?php if ($pesan): ?>
   <div class="pesan" style="color: <?= htmlspecialchars($warna) ?>;">
      <?= htmlspecialchars($pesan) ?>
   </div>
<?php endif; ?>

<a href="dashboard.php" class="button-back">⬅️ Kembali ke Dashboard</a>
</div>
</body>
</html>
