<?php
session_start();
include 'db.php';

// 🔒 Cegah akses langsung jika bukan boss
if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'boss') {
    header("Location: index.php");
    exit;
}

$pesan = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username'] ?? '');
    $sandi1 = $_POST['sandi1'] ?? '';
    $sandi2 = $_POST['sandi2'] ?? '';

    // 🔍 Validasi form
    if ($username === '' || $sandi1 === '' || $sandi2 === '') {
        $pesan = "<span style='color:red;'>Semua kolom wajib diisi!</span>";
    } elseif ($sandi1 !== $sandi2) {
        $pesan = "<span style='color:red;'>Sandi tidak sama, silakan ulangi!</span>";
    } else {
        // 🔒 Cek apakah username sudah ada
        $cek = $conn->prepare("SELECT username FROM operator WHERE username = ?");
        $cek->bind_param("s", $username);
        $cek->execute();
        $cek->store_result();

        if ($cek->num_rows > 0) {
            $pesan = "<span style='color:red;'>Username sudah digunakan!</span>";
        } else {
            $hashed = password_hash($sandi1, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("INSERT INTO operator (username, password) VALUES (?, ?)");
            $stmt->bind_param("ss", $username, $hashed);

            if ($stmt->execute()) {
                $pesan = "<span style='color:green;'>✅ Operator baru berhasil ditambahkan!</span>";
            } else {
                $pesan = "<span style='color:red;'>Gagal menambahkan operator.</span>";
            }

            $stmt->close();
        }
        $cek->close();
    }
}

$conn->close();
?>

<html>
<head>
<title>Pendaftaran Operator</title>
<style>
body {
    font-family: Verdana;
    background: #f0f0f0;
}
form {
    margin-top: 100px;
    background: #ffffff;
    border-radius: 10px;
    padding: 40px;
    width: 400px;
    box-shadow: 0 0 10px #aaa;
}
input[type=text], input[type=password] {
    width: 95%;
    padding: 8px;
    margin: 5px 0 10px 0;
    border: 1px solid #ccc;
    border-radius: 5px;
}
input[type=submit] {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
}
input[type=submit]:hover {
    background-color: #0056b3;
}
a {
    text-decoration: none;
    color: #007bff;
}
</style>
</head>

<body>
<center>
    <form method="post">
        <font size=6><b>Pendaftaran Operator</b></font><br><br>
        <?= $pesan ?><br><br>
        <label>Masukkan Username:</label><br>
        <input type="text" name="username" required><br>
        <label>Masukkan Password:</label><br>
        <input type="password" name="sandi1" required><br>
        <label>Ulangi Password:</label><br>
        <input type="password" name="sandi2" required><br><br>
        <input type="submit" value="Daftar"><br><br>
        <a href="dashboard.php">[Kembali]</a>
    </form>
</center>
</body>
</html>
