<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

// helper untuk menambah flash message
function add_flash($type, $text) {
    $_SESSION['flash'][] = ['type' => $type, 'text' => $text];
}

// ambil & bersihkan flash untuk ditampilkan
$flashes = $_SESSION['flash'] ?? [];
unset($_SESSION['flash']);

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
   die("Koneksi gagal: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $nama   = trim($_POST['nama'] ?? '');
   $alamat = trim($_POST['alamat'] ?? '');
   $telp   = trim($_POST['telp'] ?? '');
   $email  = trim($_POST['email'] ?? '');
   $nota   = trim($_POST['nota'] ?? '');

   // === Upload Gambar ===
   $target_dir   = "gambar/";
   $nama_file    = basename($_FILES["gbr"]["name"] ?? '');
   $target_file  = $target_dir . $nama_file;
   $imageFileType= strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
   $uploadOk     = 1;

   if (!empty($_FILES["gbr"]["tmp_name"])) {
       $check = @getimagesize($_FILES["gbr"]["tmp_name"]);
       if ($check === false) {
           add_flash('error', 'File bukan gambar.');
           $uploadOk = 0;
       }
       if (file_exists($target_file)) {
           add_flash('warning', 'File sudah ada, ganti nama file!');
           $uploadOk = 0;
       }
       if (($_FILES["gbr"]["size"] ?? 0) > 5000000) {
           add_flash('error', 'Ukuran file terlalu besar (maks 5MB).');
           $uploadOk = 0;
       }
       if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
           add_flash('error', 'Hanya file JPG, JPEG, PNG & GIF yang diizinkan.');
           $uploadOk = 0;
       }

       if ($uploadOk == 1) {
           if (move_uploaded_file($_FILES["gbr"]["tmp_name"], $target_file)) {
               add_flash('success', 'File ' . htmlspecialchars($nama_file) . ' berhasil diupload.');
           } else {
               add_flash('error', 'Gagal upload file.');
               $uploadOk = 0;
           }
       }
   } else {
       add_flash('info', 'Tidak ada file diupload. Logo lama digunakan.');
       $uploadOk = 0;
   }

   // === Simpan ke database ===
   if ($uploadOk == 1) {
       $stmt = $conn->prepare("UPDATE logo SET Nama_toko=?, Alamat=?, No_hape=?, Email=?, Alamat_nota=?, Gbr_toko=? LIMIT 1");
       $stmt->bind_param("ssssss", $nama, $alamat, $telp, $email, $nota, $nama_file);
       if ($stmt->execute()) {
           add_flash('success', 'Data berhasil disimpan!');
       } else {
           add_flash('error', 'Data gagal disimpan!');
       }
       $stmt->close();
   } else {
       add_flash('error', 'Data Profil Toko gagal disimpan!');
   }

   $conn->close();

   // PRG: redirect agar pesan tampil di GET dan tidak double submit
   header("Location: " . $_SERVER['PHP_SELF']);
   exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Setup Toko</title>
<style>
body {
  font-family: Verdana, sans-serif;
  background: linear-gradient(135deg, #e3f2fd, #bbdefb);
  margin: 0;
  height: 100vh;
  display: flex;
  justify-content: center;  /* horizontal center */
  align-items: center;      /* vertical center */
}

.wrapper {
  display: flex;
  flex-direction: column;
  align-items: center;
  gap: 12px;  /* jarak antar elemen (pesan & form) */
}

/* Kartu form */
form {
  background: #ffffff;
  padding: 30px 40px;
  border-radius: 15px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.15);
  width: 400px;
  text-align: center;
}

h2 {
  color: #1565c0;
  margin-bottom: 20px;
}

input[type=text],
input[type=email],
input[type=file] {
  width: 90%;
  padding: 10px;
  margin: 8px 0 15px 0;
  border: 1px solid #ccc;
  border-radius: 8px;
  font-size: 14px;
}

input[type=submit] {
  background-color: #1565c0;
  color: white;
  border: none;
  padding: 12px 30px;
  border-radius: 8px;
  font-size: 15px;
  cursor: pointer;
  transition: background 0.3s;
}

input[type=submit]:hover {
  background-color: #0d47a1;
}

a {
  color: #1565c0;
  text-decoration: none;
  display: block;
  margin-top: 15px;
}

a:hover {
  text-decoration: underline;
}

/* Flash messages */
.msg {
  padding: 10px 14px;
  border-radius: 8px;
  width: 400px;
  text-align: center;
  font-size: 14px;
  box-sizing: border-box;
  border: 1px solid transparent;
}
.msg.success { background: #c8e6c9; color: #1b5e20; border-color: #a5d6a7; }
.msg.error   { background: #ffcdd2; color: #b71c1c; border-color: #ef9a9a; }
.msg.warning { background: #fff3cd; color: #856404; border-color: #ffe08a; }
.msg.info    { background: #bbdefb; color: #0d47a1; border-color: #90caf9; }
</style>
</head>

<body>
<div class="wrapper">
  <!-- Tampilkan semua flash message -->
  <?php if (!empty($flashes)): ?>
    <?php foreach ($flashes as $f): ?>
      <div class="msg <?= htmlspecialchars($f['type']) ?>">
        <?= htmlspecialchars($f['text']) ?>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <h2>🛍️ Setup Profil Toko</h2>

    <label>Nama Toko:</label><br>
    <input type="text" name="nama"><br>

    <label>Alamat Toko:</label><br>
    <input type="text" name="alamat"><br>

    <label>Nomor Hape:</label><br>
    <input type="text" name="telp"><br>

    <label>Email:</label><br>
    <input type="email" name="email"><br>
    
    <label>Alamat di Nota:</label><br>
    <input type="text" name="nota" value="max. 30 chars"><br>

    <label>Logo Toko:</label><br>
    <input type="file" name="gbr" accept="image/*"><br><br>

    <input type="submit" value="💾 Simpan Data">
    <a href="dashboard.php">⬅️ Kembali</a>
  </form>
</div>
</body>
</html>
