<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

include 'db.php';
require('fpdf.php');

// === Data dari form ===
$no_trans   = $_POST['no_trans'];
$kasir      = $_POST['kasir'];
$total      = $_POST['total_bayar'];
$dibayar    = $_POST['dibayar'];
$kembalian  = $dibayar - $total;

// === Simpan header transaksi ===
$stmt = $conn->prepare("INSERT INTO transaksi (no_trans, tanggal, kasir, total_bayar, dibayar, kembalian)
                        VALUES (?, NOW(), ?, ?, ?, ?)");
$stmt->bind_param("ssiii", $no_trans, $kasir, $total, $dibayar, $kembalian);
$stmt->execute();
$id_transaksi = $stmt->insert_id;
$stmt->close();

// === Simpan detail barang ===
$barkode   = $_POST['barkode'];
$nama      = $_POST['nama_barang'];
$harga     = $_POST['harga'];
$jumlah    = $_POST['jumlah'];
$subtotal  = $_POST['subtotal'];

for ($i = 0; $i < count($barkode); $i++) {
    if (trim($barkode[$i]) == '') continue;

    $stmt2 = $conn->prepare("INSERT INTO detail_transaksi 
        (id_transaksi, barkode, nama_barang, harga, jumlah, subtotal)
        VALUES (?, ?, ?, ?, ?, ?)");
    $stmt2->bind_param("issiii", $id_transaksi, $barkode[$i], $nama[$i], $harga[$i], $jumlah[$i], $subtotal[$i]);
    $stmt2->execute();
    $stmt2->close();

    // Kurangi stok
    $stmt3 = $conn->prepare("UPDATE barang SET stok = stok - ? WHERE barkode = ?");
    $stmt3->bind_param("is", $jumlah[$i], $barkode[$i]);
    $stmt3->execute();
    $stmt3->close();
}

// === ambil data profil TOKO

$stmt = $conn->prepare("SELECT Nama_toko, Alamat, No_hape, Email, Alamat_nota FROM logo LIMIT 1");
$stmt->execute();
$stmt->bind_result($namatoko, $alamattoko, $nohp, $emailtoko, $alamat_nota);
$stmt->fetch();
$stmt->close();





// === CETAK STRUK ===
$pdf = new FPDF('P', 'mm', array(80, 200)); // ukuran thermal 80mm
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(60, 7, "$namatoko", 0, 1, 'C');
$pdf->SetFont('Arial', '', 10);
$pdf->Cell(60, 5, "$alamat_nota", 0, 1, 'C');
$pdf->Cell(60, 5, "No.Hape: $nohp", 0, 1, 'C');
$pdf->Ln(2);
$pdf->Cell(60, 0, str_repeat('-', 40), 0, 1, 'C');
$pdf->Ln(2);

$pdf->SetFont('Arial', '', 9);
$pdf->Cell(60, 5, "No: $no_trans", 0, 1);
$pdf->Cell(60, 5, "Kasir: $kasir", 0, 1);
$pdf->Cell(60, 5, "Tanggal: " . date('d-m-Y H:i'), 0, 1);
$pdf->Ln(2);
$pdf->Cell(60, 0, str_repeat('-', 40), 0, 1, 'C');
$pdf->Ln(3);

// tampilkan barang
$pdf->SetFont('Arial', '', 9);
for ($i = 0; $i < count($barkode); $i++) {
    if (trim($barkode[$i]) == '') continue;
    $pdf->Cell(40, 5, $nama[$i], 0, 0);
    $pdf->Cell(10, 5, $jumlah[$i], 0, 0, 'C');
    $pdf->Cell(20, 5, number_format($subtotal[$i]), 0, 1, 'R');
}
$pdf->Ln(2);
$pdf->Cell(60, 0, str_repeat('-', 40), 0, 1, 'C');
$pdf->Ln(3);

$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(40, 5, 'Total', 0, 0);
$pdf->Cell(20, 5, 'Rp ' . number_format($total), 0, 1, 'R');
$pdf->Cell(40, 5, 'Dibayar', 0, 0);
$pdf->Cell(20, 5, 'Rp ' . number_format($dibayar), 0, 1, 'R');
$pdf->Cell(40, 5, 'Kembalian', 0, 0);
$pdf->Cell(20, 5, 'Rp ' . number_format($kembalian), 0, 1, 'R');

$pdf->Ln(5);
$pdf->SetFont('Arial', '', 9);
$pdf->Cell(60, 5, 'Terima kasih telah berbelanja!', 0, 1, 'C');
$pdf->Cell(60, 5, 'Barang yang sudah dibeli tidak dapat dikembalikan', 0, 1, 'C');

// tampilkan PDF langsung di browser
$pdf->Output('I', "struk_$no_trans.pdf");

$conn->close();
?>
