<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

// Koneksi ke database
$koneksi = mysqli_connect($servername, $username, $password, $database);

// Cek koneksi
if (!$koneksi) {
    die("Koneksi gagal: " . mysqli_connect_error());
}

// Query data transaksi
$sql = "
SELECT 
  transaksi.no_id,
  transaksi.Tanggal,
  pelanggan.Nama,
  pelanggan.Alamat,
  pelanggan.Email,
  pelanggan.No_hape,
  barang.Nama_barang,
  barang.Harga,
  barang.Diskon,
  transaksi.Jumlah_beli
FROM transaksi
JOIN pelanggan ON transaksi.no_plg = pelanggan.no_id
JOIN barang ON transaksi.no_brg = barang.no_id
ORDER BY transaksi.Tanggal DESC
";

$hasil = mysqli_query($koneksi, $sql);

// Fungsi format tanggal Indonesia
function formatTanggalIndo($tanggal)
{
    $bulan = [
        1 => 'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    ];
    $pecah = explode('-', $tanggal);
    return $pecah[2] . ' ' . $bulan[(int)$pecah[1]] . ' ' . $pecah[0];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Transaksi</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background-color: #f9f9f9;
    }
    table {
        border-collapse: collapse;
        width: 95%;
    }
    th, td {
        border: 1px solid #000;
        padding: 8px;
        text-align: center;
    }
    th {
        background-color: #ffffff;
    }
    td {
        background-color: #ffffff;
    }
    .total-row {
        background-color: #ccffcc;
        font-weight: bold;
    }
    .print-button {
        margin-top: 25px;
    }
    /* Sembunyikan tombol saat dicetak */
    @media print {
        .print-button {
            display: none;
        }
    }
</style>
</head>
<body>

<center>
    <h1>Data Transaksi</h1>
    <table>
        <tr>
            <th>No. Transaksi</th>
            <th>Tanggal</th>
            <th>Nama Pelanggan</th>
            <th>Alamat</th>
            <th>Email</th>
            <th>No. Hape</th>
            <th>Nama Barang</th>
            <th>Harga Satuan</th>
            <th>Diskon (%)</th>
            <th>Jumlah Beli</th>
            <th>Total</th>
        </tr>

        <?php
        $total_semua = 0;
        if (mysqli_num_rows($hasil) > 0) {
            while ($row = mysqli_fetch_assoc($hasil)) {
                $tanggal_format = formatTanggalIndo($row['Tanggal']);
                $harga_setelah_diskon = $row['Harga'] - ($row['Harga'] * ($row['Diskon'] / 100));
                $total = $row['Jumlah_beli'] * $harga_setelah_diskon;
                $total_semua += $total;

                echo "<tr>";
                echo "<td>{$row['no_id']}</td>";
                echo "<td>{$tanggal_format}</td>";
                echo "<td>{$row['Nama']}</td>";
                echo "<td>{$row['Alamat']}</td>";
                echo "<td>{$row['Email']}</td>";
                echo "<td>{$row['No_hape']}</td>";
                echo "<td>{$row['Nama_barang']}</td>";
                echo "<td>" . number_format($row['Harga'], 0, ',', '.') . "</td>";
                echo "<td>{$row['Diskon']}</td>";
                echo "<td>{$row['Jumlah_beli']}</td>";
                echo "<td>" . number_format($total, 0, ',', '.') . "</td>";
                echo "</tr>";
            }

            // Baris total semua transaksi (hijau muda)
            echo "<tr class='total-row'>";
            echo "<td colspan='10' align='right'>Total Semua Transaksi :</td>";
            echo "<td>" . number_format($total_semua, 0, ',', '.') . "</td>";
            echo "</tr>";
        } else {
            echo "<tr><td colspan='11'><b>Tidak ada data ditemukan.</b></td></tr>";
        }

        // Tutup koneksi
        mysqli_close($koneksi);
        ?>
    </table>

    <div class="print-button">
        <button onclick="window.print()" style="margin-top:20px; padding:10px 25px; font-size:16px; background-color:#4CAF50; color:white; border:none; border-radius:6px; cursor:pointer;">
            🖨️ Cetak Laporan
        </button>
    </div><br><br><br>
</center>

</body>
</html>
