<?php
session_start();

include 'db.php';

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$pesan = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $brg_hapus = trim($_POST['brg'] ?? '');
    $pass_admin = trim($_POST['password'] ?? '');
    $admin_email = $_SESSION['username'];

    // 🔐 Verifikasi password admin (kolom EMAIL & PASSWORD di tabel users)
    $cek = $conn->prepare("SELECT password FROM users WHERE username = ?");
    $cek->bind_param("s", $admin_email);
    $cek->execute();
    $cek->bind_result($hash);
    $cek->fetch();
    $cek->close();

    if (!$hash || !password_verify($pass_admin, $hash)) {
        $pesan = "<p style='color:red;'>❌ Password salah. Penghapusan dibatalkan.</p>";
    } else {
        // 1️⃣ Ambil data barang sebelum dihapus
        $sql = "SELECT * FROM barang WHERE LOWER(Nama_barang) LIKE LOWER(?)";
        $stmt = $conn->prepare($sql);
        $search = "%$brg_hapus%";
        $stmt->bind_param("s", $search);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                // 2️⃣ Simpan data ke recycle bin
                $ins = $conn->prepare("INSERT INTO barang_deleted 
                    (Nama_barang, Harga, Stok, Diskon, Gbr_brg, Deleted_at)
                    VALUES (?, ?, ?, ?, ?, NOW())");
                $ins->bind_param("siiss", 
                    $row['Nama_barang'], 
                    $row['Harga'], 
                    $row['Stok'], 
                    $row['Diskon'], 
                    $row['Gbr_brg']
                );
                $ins->execute();

                // 3️⃣ Simpan ke log admin
                $ket = "Menghapus barang: " . $row['Nama_barang'];
                $log = $conn->prepare("INSERT INTO admin_log (admin, aksi, waktu, keterangan) 
                                       VALUES (?, 'hapus', NOW(), ?)");
                $log->bind_param("ss", $admin_email, $ket);
                $log->execute();

                // 4️⃣ Hapus barang dari tabel utama
                $del = $conn->prepare("DELETE FROM barang WHERE Nama_barang = ?");
                $del->bind_param("s", $row['Nama_barang']);
                $del->execute();
            }

            $pesan = "<p style='color:green;'>✅ Barang berhasil dihapus dan log tersimpan.</p>";
        } else {
            $pesan = "<p style='color:red;'>❌ Barang tidak ditemukan.</p>";
        }
    }
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Hapus Barang - Konfirmasi Aman</title>
<style>
body {
    font-family: Arial, sans-serif;
    background-color: #f6f7fb;
    color: #333;
    padding: 40px;
}
.container {
    background: white;
    padding: 25px;
    max-width: 500px;
    margin: auto;
    border-radius: 10px;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
h2 {
    text-align: center;
    color: #007BFF;
}
input[type=text], input[type=password] {
    width: 100%;
    padding: 10px;
    margin-top: 8px;
    margin-bottom: 15px;
    border: 1px solid #ccc;
    border-radius: 6px;
}
button {
    background-color: #dc3545;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 6px;
    cursor: pointer;
}
button:hover {
    background-color: #b02a37;
}
.message {
    text-align: center;
    margin-bottom: 15px;
}
</style>
</head>
<body>

<div class="container">
    <h2>🗑️ Hapus Barang (Konfirmasi)</h2>

    <div class="message"><?= $pesan ?></div>

    <form method="post" action="">
        <label>Nama Barang:</label>
        <input type="text" name="brg" placeholder="Masukkan nama barang..." required>

        <label>Password Admin:</label>
        <input type="password" name="password" placeholder="Masukkan password admin..." required>

        <button type="submit">Hapus Barang</button>
    </form>

    <p style="text-align:center; margin-top:20px;">
        <a href="admin_dashboard.php" style="text-decoration:none; color:#007BFF;">⬅️ Kembali ke Dashboard</a>
    </p>
</div>

</body>
</html>
