<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) die("Koneksi gagal: " . $conn->connect_error);

$id = intval($_POST['id'] ?? 0);
if ($id <= 0) die("ID tidak valid.");

// Jika password belum dikirim, tampilkan form input password
if (!isset($_POST['admin_pass'])) {
    ?>
    <form method="post">
        <h3>⚠️ Konfirmasi Hapus Permanen</h3>
        <input type="hidden" name="id" value="<?= $id ?>">
        Masukkan password admin: <input type="password" name="admin_pass" required>
        <button type="submit">Hapus Permanen</button>
    </form>
    <?php
    exit;
}

// Cek password admin
$input_pass = $_POST['admin_pass'];
$email_admin = $_SESSION['username'];

// Ambil hash password dari users
$stmt = $conn->prepare("SELECT password FROM users WHERE email = ?");
$stmt->bind_param("s", $email_admin);
$stmt->execute();
$stmt->bind_result($hash);
$stmt->fetch();
$stmt->close();

if (!password_verify($input_pass, $hash)) {
    echo "<script>alert('Password salah!'); window.location='recycle_bin.php';</script>";
    exit;
}

// Ambil data barang (untuk log)
$stmt = $conn->prepare("SELECT Nama_barang FROM barang_deleted WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->bind_result($nama_brg);
$stmt->fetch();
$stmt->close();

// Hapus permanen
$stmt = $conn->prepare("DELETE FROM barang_deleted WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$stmt->close();

// Catat log admin
$aksi = "Hapus permanen barang: $nama_brg";
$log = $conn->prepare("INSERT INTO admin_log (email_admin, aksi, waktu) VALUES (?, ?, NOW())");
$log->bind_param("ss", $email_admin, $aksi);
$log->execute();
$log->close();

$conn->close();

echo "<script>alert('Barang berhasil dihapus permanen!'); window.location='recycle_bin.php';</script>";
?>
