<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername,$username,$password,$database);
if ($conn->connect_error) die("Koneksi gagal: ".$conn->connect_error);

$admin_email = $_SESSION['username'];

// Form input password
if(!isset($_POST['admin_pass'])) {
    echo '<form method="post">
            Masukkan password admin untuk hapus permanen semua: 
            <input type="password" name="admin_pass" required>
            <button type="submit">Hapus Semua</button>
          </form>';
    exit;
}

// Cek password
$input_pass = $_POST['admin_pass'];
$stmt = $conn->prepare("SELECT password FROM users WHERE email=?");
$stmt->bind_param("s",$admin_email);
$stmt->execute();
$stmt->bind_result($hash);
$stmt->fetch();
$stmt->close();

if(!password_verify($input_pass,$hash)) {
    echo "<script>alert('Password salah!'); window.location='recycle_bin.php';</script>";
    exit;
}

// Ambil semua data untuk log
$result = $conn->query("SELECT Nama_barang FROM barang_deleted");
$conn->begin_transaction();
try {
    while($row = $result->fetch_assoc()){
        $aksi = "Hapus permanen semua: ".$row['Nama_barang'];
        $log = $conn->prepare("INSERT INTO admin_log (email_admin, aksi, waktu) VALUES (?,?,NOW())");
        $log->bind_param("ss",$admin_email,$aksi);
        $log->execute();
        $log->close();
    }

    // Hapus semua
    $conn->query("DELETE FROM barang_deleted");
    $conn->commit();

    echo "<script>alert('Semua barang dihapus permanen!'); window.location='recycle_bin.php';</script>";
} catch(Exception $e){
    $conn->rollback();
    echo "<script>alert('Gagal: ".$e->getMessage()."'); window.location='recycle_bin.php';</script>";
}

$conn->close();
?>
