<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


// Ambil data dari form
$nama_brg = trim($_POST['nama_brg'] ?? '');
$harga = $_POST['rego'] ?? 0;
$stok = $_POST['sisa'] ?? 0;
$diskon = $_POST['diskon'] ?? 0;

// Ambil data file upload
$target_dir = "gambar/";
$nama_file = basename($_FILES["gbr_brg"]["name"]);
$target_file = $target_dir . $nama_file;
$imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
$uploadOk = 1;

// --- Validasi file upload ---
if (isset($_FILES["gbr_brg"]["tmp_name"]) && $_FILES["gbr_brg"]["tmp_name"] != "") {
    $check = getimagesize($_FILES["gbr_brg"]["tmp_name"]);
    if ($check === false) {
        echo "File bukan gambar.<br>";
        $uploadOk = 0;
    }

    if (file_exists($target_file)) {
        echo "Maaf, file sudah ada.<br>";
        $uploadOk = 0;
    }

    if ($_FILES["gbr_brg"]["size"] > 5000000) {
        echo "Maaf, ukuran file terlalu besar (max 5MB).<br>";
        $uploadOk = 0;
    }

    if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
        echo "Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
        $uploadOk = 0;
    }

    // Upload file jika semua valid
    if ($uploadOk == 1) {
        if (move_uploaded_file($_FILES["gbr_brg"]["tmp_name"], $target_file)) {
            echo "File " . htmlspecialchars($nama_file) . " berhasil diupload.<br>";
        } else {
            echo "Maaf, terjadi kesalahan saat mengupload file.<br>";
            $uploadOk = 0;
        }
    }
} else {
    echo "Tidak ada file diupload.<br>";
    $uploadOk = 0;
}

// Hanya lanjut simpan ke database kalau upload berhasil
if ($uploadOk == 1) {
    $conn = new mysqli($servername, $username, $password, $database);

    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    $stmt = $conn->prepare("INSERT INTO barang (Nama_barang, Harga, Stok, Diskon, Gbr_brg) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("siiis", $nama_brg, $harga, $stok, $diskon, $nama_file);

    if ($stmt->execute()) {
        echo "<b>Data barang berhasil disimpan.</b>";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>

<html>

<head>
    
<title>Data Barang</title>    
    
</head>

<body>

<br><br><center><font face=verdana size=6>Data Barang</font></center><br><br>

<form method="post" enctype="multipart/form-data">
  <table border="0" align="center">
    <tr>
      <td><font face=verdana>Nama Barang</font></td>
      <td><input type="text" name="nama_brg" size="50" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr>
      <td><font face=verdana>Harga Barang</font></td>
      <td><input type="number" name="rego" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr>
      <td><font face=verdana>Stok</font></td>
      <td><input type="number" name="sisa" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr>
      <td><font face=verdana>Discount (satuan % / 0-100)</font></td>
      <td><input type="number" name="diskon" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr>
      <td><font face=verdana>Foto Barang</font></td>
      <td><input type="file" name="gbr_brg" accept="gambar/*" required></td>
    </tr>
    <tr><td colspan="2" align="center">
      <br><br><button type="submit" onclick="this.disabled=true; this.form.submit();">Kirim</button><br><br><br>
    </td></tr>
  </table>
</form>
<center><a href="admin_dashboard.php"><font face=verdana size=3>[Kembali]</font></a></center>
</body>
</html>







