<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername,$username,$password,$database);
if ($conn->connect_error) die("Koneksi gagal: ".$conn->connect_error);

$admin_email = $_SESSION['username'];

// Cari restore terakhir dari admin_log
$stmt = $conn->prepare("SELECT aksi FROM admin_log WHERE email_admin=? AND aksi LIKE 'Pulihkan%' ORDER BY id DESC LIMIT 1");
$stmt->bind_param("s",$admin_email);
$stmt->execute();
$stmt->bind_result($last_action);
$stmt->fetch();
$stmt->close();

if(!$last_action){
    echo "<script>alert('Tidak ada restore terakhir untuk dibatalkan.'); window.location='recycle_bin.php';</script>";
    exit;
}

// Ambil nama barang dari log
preg_match("/Pulihkan.*: (.+)/",$last_action,$matches);
if(!isset($matches[1])){
    echo "<script>alert('Gagal membaca log restore.'); window.location='recycle_bin.php';</script>";
    exit;
}
$nama_brg = $matches[1];

// Ambil data barang di tabel barang
$stmt = $conn->prepare("SELECT * FROM barang WHERE Nama_barang=? ORDER BY id DESC LIMIT 1");
$stmt->bind_param("s",$nama_brg);
$stmt->execute();
$result = $stmt->get_result();
if($result->num_rows==0){
    echo "<script>alert('Barang tidak ditemukan di tabel barang.'); window.location='recycle_bin.php';</script>";
    exit;
}
$barang = $result->fetch_assoc();
$stmt->close();

// Masukkan kembali ke recycle bin
$stmt = $conn->prepare("INSERT INTO barang_deleted (Nama_barang,Harga,Stok,Diskon,Gbr_brg,Deleted_at) VALUES (?,?,?,?,?,NOW())");
$stmt->bind_param("siiss",$barang['Nama_barang'],$barang['Harga'],$barang['Stok'],$barang['Diskon'],$barang['Gbr_brg']);
$stmt->execute();
$stmt->close();

// Hapus dari tabel barang
$stmt = $conn->prepare("DELETE FROM barang WHERE id=?");
$stmt->bind_param("i",$barang['id']);
$stmt->execute();
$stmt->close();

// Log Undo
$aksi = "Undo restore: ".$barang['Nama_barang'];
$log = $conn->prepare("INSERT INTO admin_log (email_admin, aksi, waktu) VALUES (?,?,NOW())");
$log->bind_param("ss",$admin_email,$aksi);
$log->execute();
$log->close();

$conn->close();
echo "<script>alert('Restore terakhir berhasil dibatalkan!'); window.location='recycle_bin.php';</script>";
?>
