<?php

session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$namabrg = trim($_POST['nama_brg'] ?? '');
$aksi    = $_POST['aksi'] ?? '';

// ===================================================
// MODE 1 — CARI DATA
// ===================================================
if ($aksi === 'cari' && !empty($namabrg)) {
    $stmt = $conn->prepare("SELECT no_id, Nama_barang, Harga, Stok, Gbr_brg FROM barang WHERE Nama_barang = ?");
    $stmt->bind_param("s", $namabrg);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        $data_barang = $row;
        echo "<center><b>Data ditemukan. Silakan ubah di bawah ini.</b></center><br>";
    } else {
        echo "<center><font color=red><b>Data barang tidak ditemukan!</b></font></center>";
    }
    $stmt->close();
}

// ===================================================
// MODE 2 — UPDATE DATA
// ===================================================
if ($aksi === 'update') {
    $no_id     = (int) ($_POST['no_id'] ?? 0);
    $nama_baru = trim($_POST['namaku'] ?? '');
    $harga     = (int) ($_POST['rego'] ?? 0);
    $stok      = (int) ($_POST['sisa'] ?? 0);
    $diskon    = (int) ($_POST['diskon'] ?? 0);

    $target_dir  = "gambar/";
    $nama_file   = basename($_FILES["gambar_brg"]["name"] ?? '');
    $target_file = $target_dir . $nama_file;
    $uploadOk    = 1;
    $gambar_baru = '';

    // --- Jika ada file baru diupload ---
    if (!empty($_FILES["gambar_brg"]["tmp_name"])) {
        $check = getimagesize($_FILES["gambar_brg"]["tmp_name"]);
        if ($check === false) {
            echo "File bukan gambar.<br>";
            $uploadOk = 0;
        }

        if ($_FILES["gambar_brg"]["size"] > 5000000) {
            echo "Ukuran file terlalu besar (max 5MB).<br>";
            $uploadOk = 0;
        }

        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
            echo "Hanya file JPG, JPEG, PNG & GIF diizinkan.<br>";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["gambar_brg"]["tmp_name"], $target_file)) {
                $gambar_baru = $nama_file;
                echo "File berhasil diupload.<br>";
            } else {
                echo "Gagal upload file.<br>";
                $uploadOk = 0;
            }
        }
    }

    // --- Ambil gambar lama jika tidak upload baru ---
    if (empty($gambar_baru)) {
        $res = $conn->query("SELECT Gbr_brg FROM barang WHERE no_id=$no_id");
        if ($res && $row = $res->fetch_assoc()) {
            $gambar_baru = $row['Gbr_brg'];
        }
    }

    // --- Update data ke database ---
    if ($no_id > 0 && $nama_baru !== '') {
        $stmt = $conn->prepare("UPDATE barang SET Nama_barang=?, Harga=?, Stok=?, Diskon=?, Gbr_brg=? WHERE no_id=?");
        $stmt->bind_param("siiisi", $nama_baru, $harga, $stok, $diskon, $gambar_baru, $no_id);

        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                echo "<center><font color=green><b>✅ Data berhasil diupdate!</b></font></center>";
            } else {
                echo "<center><font color=orange><b>⚠️ Tidak ada perubahan data.</b></font></center>";
            }
        } else {
            echo "<center><font color=red><b>❌ Error: {$stmt->error}</b></font></center>";
        }
        $stmt->close();
    } else {
        echo "<center><font color=red><b>Data tidak lengkap!</b></font></center>";
    }
}

$conn->close();
?>

<!-- =================================================== -->
<!-- FORM HTML -->
<!-- =================================================== -->
<html>
<head>
    <title>Update Data Barang</title>
    <meta charset="UTF-8">
</head>
<body>

<center>
    <h2>Cari Barang</h2>
    <form method="post">
        Nama Barang: <input type="text" name="nama_brg" required>
        <button type="submit" name="aksi" value="cari">Cari</button>
    </form>
</center>

<?php if (!empty($data_barang)): ?>
<hr>
<center>
    <h2>Form Update Barang</h2>
    <form enctype="multipart/form-data" method="post">
        <input type="hidden" name="no_id" value="<?= htmlspecialchars($data_barang['no_id']); ?>">
        <table>
            <tr>
                <td>No ID</td>
                <td><b><?= htmlspecialchars($data_barang['no_id']); ?></b></td>
            </tr>
            <tr>
                <td>Nama Barang</td>
                <td><input type="text" name="namaku" value="<?= htmlspecialchars($data_barang['Nama_barang']); ?>"></td>
            </tr>
            <tr>
                <td>Harga</td>
                <td><input type="number" name="rego" value="<?= htmlspecialchars($data_barang['Harga']); ?>"></td>
            </tr>
            <tr>
                <td>Stok</td>
                <td><input type="number" name="sisa" value="<?= htmlspecialchars($data_barang['Stok']); ?>"></td>
            </tr>
            <tr>
                <td>Discount (%)</td>
                <td><input type="number" name="diskon" value="<?= htmlspecialchars($data_barang['Diskon']); ?>"></td>
            </tr>
            <tr>
                <td>Gambar Lama</td>
                <td>
                    <?php if (!empty($data_barang['Gbr_brg'])): ?>
                        <img src="gambar/<?= htmlspecialchars($data_barang['Gbr_brg']); ?>" width="100"><br>
                    <?php endif; ?>
                    <input type="file" accept="image/*" name="gambar_brg">
                </td>
            </tr>
            <tr>
                <td colspan="2" align="center">
                    <button type="submit" name="aksi" value="update">💾 Simpan Perubahan</button>
                </td>
            </tr>
        </table>
    </form>
</center>
<?php endif; ?>
<br><br><br>
<center><a href="admin_dashboard.php"><font face=verdana size=3>[Kembali]</font></a></center>
</body>
</html>
