<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email_hapus = trim($_POST['surat'] ?? '');

    if (empty($email_hapus)) {
        $message = "<div class='alert alert-error'>❌ Email pelanggan tidak boleh kosong.</div>";
    } else {
        // 🔍 Ambil data lengkap pelanggan (termasuk foto)
        $cek = $conn->prepare("SELECT Nama, Alamat, Email, No_hape, Gbr_plg FROM pelanggan WHERE Email = ?");
        $cek->bind_param("s", $email_hapus);
        $cek->execute();
        $hasil = $cek->get_result();
        $data = $hasil->fetch_assoc();
        $cek->close();

        if ($data) {
            $tanggal_hapus = date('Y-m-d H:i:s');

            // ♻️ Pindahkan ke recycle bin termasuk foto
            $ins = $conn->prepare("
                INSERT INTO pelanggan_deleted (Nama, Alamat, Email, No_hape, Gbr_plg, Tanggal_dihapus)
                VALUES (?, ?, ?, ?, ?, ?)
            ");
            $ins->bind_param("ssssss", $data['Nama'], $data['Alamat'], $data['Email'], $data['No_hape'], $data['Gbr_plg'], $tanggal_hapus);
            $ins->execute();
            $ins->close();

            // 🗑️ Hapus dari tabel utama
            $del = $conn->prepare("DELETE FROM pelanggan WHERE Email = ?");
            $del->bind_param("s", $email_hapus);
            $del->execute();
            $del->close();

            $message = "<div class='alert alert-success'>✅ Data pelanggan <b>" . htmlspecialchars($data['Nama']) . "</b> berhasil dipindahkan ke Recycle Bin (foto ikut tersimpan).</div>";
        } else {
            $message = "<div class='alert alert-error'>⚠️ Email tidak ditemukan dalam database pelanggan.</div>";
        }
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Hapus Data Pelanggan - Admin Panel</title>
<style>
    body {
        background: linear-gradient(135deg, #f0f4f8, #dceefb);
        font-family: "Segoe UI", sans-serif;
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100vh;
        margin: 0;
    }

    .container {
        background: #fff;
        width: 420px;
        padding: 30px 35px;
        border-radius: 16px;
        box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        text-align: center;
    }

    h2 {
        color: #333;
        margin-bottom: 20px;
    }

    form {
        margin-top: 10px;
    }

    label {
        display: block;
        text-align: left;
        font-weight: 600;
        color: #555;
        margin-bottom: 6px;
    }

    input[type="email"] {
        width: 100%;
        padding: 10px;
        border: 2px solid #ddd;
        border-radius: 8px;
        font-size: 15px;
        transition: 0.2s;
    }

    input[type="email"]:focus {
        border-color: #3b82f6;
        outline: none;
        box-shadow: 0 0 4px #60a5fa;
    }

    button {
        background: #3b82f6;
        color: white;
        border: none;
        padding: 10px 18px;
        border-radius: 8px;
        margin-top: 15px;
        cursor: pointer;
        font-size: 15px;
        transition: 0.25s;
    }

    button:hover {
        background: #2563eb;
        transform: translateY(-1px);
    }

    .alert {
        padding: 12px;
        margin-top: 20px;
        border-radius: 8px;
        font-weight: 600;
    }

    .alert-success {
        background: #dcfce7;
        color: #166534;
        border: 1px solid #86efac;
    }

    .alert-error {
        background: #fee2e2;
        color: #991b1b;
        border: 1px solid #fca5a5;
    }

    .footer {
        margin-top: 25px;
        font-size: 13px;
        color: #777;
    }

    .footer a {
        color: #3b82f6;
        text-decoration: none;
        font-weight: 600;
    }

    .footer a:hover {
        text-decoration: underline;
    }
</style>
</head>

<body>
<div class="container">
    <h2>🧹 Hapus Data Pelanggan</h2>
    <form method="post">
        <label for="surat">Email Pelanggan:</label>
        <input type="email" name="surat" id="surat" placeholder="contoh: user@email.com" required>
        <button type="submit">Hapus Pelanggan</button>
    </form>
    <?= $message ?>
    <div class="footer">
        <p><a href="recycle_bin_pelanggan.php">📁 Lihat Recycle Bin</a> | <a href="admin_dashboard.php">🏠 Kembali ke Dashboard</a></p>
    </div>
</div>
</body>
</html>
