<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

// Koneksi ke database
$koneksi = mysqli_connect($servername, $username, $password, $database);

// Cek koneksi
if (!$koneksi) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars(mysqli_connect_error()) . "</p>");
}

// Ambil kata kunci pencarian (jika ada)
$cari = trim($_GET['cari'] ?? '');

// Query pencarian (tidak case-sensitive, LIKE sebagian kata)
if ($cari !== '') {
    $sql = "SELECT * FROM barang WHERE LOWER(Nama_barang) LIKE LOWER(?) ORDER BY no_id ASC";
    $stmt = mysqli_prepare($koneksi, $sql);
    $param = "%" . $cari . "%";
    mysqli_stmt_bind_param($stmt, "s", $param);
    mysqli_stmt_execute($stmt);
    $hasil = mysqli_stmt_get_result($stmt);
} else {
    $sql = "SELECT * FROM barang ORDER BY no_id ASC";
    $hasil = mysqli_query($koneksi, $sql);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Barang - Admin</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background-color: #f9f9f9;
        color: #333;
        margin: 0;
        padding: 0;
    }
    h1 {
        text-align: center;
        color: #222;
        margin-top: 40px;
    }
    form {
        text-align: center;
        margin: 20px 0;
    }
    input[type="text"] {
        padding: 10px;
        width: 300px;
        border-radius: 5px;
        border: 1px solid #999;
        font-size: 14px;
    }
    input[type="submit"] {
        padding: 10px 18px;
        border: none;
        background-color: #0073e6;
        color: white;
        border-radius: 5px;
        cursor: pointer;
        font-size: 14px;
        margin-left: 5px;
    }
    input[type="submit"]:hover {
        background-color: #005bb5;
    }
    table {
        border-collapse: collapse;
        width: 90%;
        margin: 30px auto;
        background-color: #fff;
        box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }
    th {
        background-color: #0073e6;
        color: white;
        padding: 10px;
        text-align: center;
    }
    td {
        padding: 10px;
        border-bottom: 1px solid #ccc;
        text-align: center;
    }
    tr:hover {
        background-color: #f1f7ff;
    }
    img {
        border-radius: 8px;
        border: 1px solid #ccc;
        width: 120px;
        height: auto;
    }
    .no-data {
        text-align: center;
        margin-top: 50px;
        color: red;
        font-size: 18px;
    }
</style>
</head>
<body>

<h1>📦 Daftar Barang</h1>

<form method="get" action="">
    <input type="text" name="cari" placeholder="Cari nama barang..." value="<?php echo htmlspecialchars($cari); ?>">
    <input type="submit" value="Cari">
    <?php if ($cari !== ''): ?>
        <a href="<?php echo basename($_SERVER['PHP_SELF']); ?>" style="margin-left:10px;color:#0073e6;text-decoration:none;">🔄 Reset</a>
    <?php endif; ?>
</form>

<?php
if (mysqli_num_rows($hasil) > 0) {
    echo "<table>";
    echo "<tr>
            <th>No</th>
            <th>Nama Barang</th>
            <th>Harga (Rp)</th>
            <th>Stok</th>
            <th>Diskon (%)</th>
            <th>Gambar</th>
          </tr>";

    while ($row = mysqli_fetch_assoc($hasil)) {
        $harga = number_format($row['Harga'], 0, ',', '.');
        $gambar = htmlspecialchars($row['Gbr_brg']);
        echo "<tr>
                <td>{$row['no_id']}</td>
                <td>".htmlspecialchars($row['Nama_barang'])."</td>
                <td>Rp $harga</td>
                <td>{$row['Stok']}</td>
                <td>{$row['Diskon']}</td>
                <td><img src='gambar/$gambar' alt='Gambar Barang'></td>
              </tr>";
    }
    echo "</table>";
} else {
    echo "<div class='no-data'>Tidak ada data barang ditemukan.</div>";
}

// Tutup koneksi
mysqli_close($koneksi);
?>

</body>
</html>
