<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

// Koneksi ke database
$koneksi = mysqli_connect($servername, $username, $password, $database);
if (!$koneksi) {
    die("Koneksi gagal: " . mysqli_connect_error());
}

// Jika tombol export diklik → kirim header Excel
if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=Laporan_Transaksi_" . date('Ymd_His') . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

// Query data transaksi
$sql = "
SELECT 
  transaksi.no_id,
  transaksi.Tanggal,
  pelanggan.Nama,
  pelanggan.Alamat,
  pelanggan.Email,
  pelanggan.No_hape,
  barang.Nama_barang,
  barang.Harga,
  barang.Diskon,
  transaksi.Jumlah_beli
FROM transaksi
JOIN pelanggan ON transaksi.no_plg = pelanggan.no_id
JOIN barang ON transaksi.no_brg = barang.no_id
ORDER BY transaksi.Tanggal DESC
";
$hasil = mysqli_query($koneksi, $sql);

// Fungsi format tanggal Indonesia
function formatTanggalIndo($tanggal)
{
    if (!$tanggal) return '-';
    $bulan = [
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    $pecah = explode('-', $tanggal);
    return $pecah[2] . ' ' . $bulan[(int)$pecah[1]] . ' ' . $pecah[0];
}
?>

<?php if (!isset($_GET['export'])): ?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Laporan Data Transaksi</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background-color: #f3f4f6;
        color: #222;
        margin: 40px;
    }
    h1 {
        text-align: center;
        color: #2b2b2b;
        margin-bottom: 10px;
    }
    .subtitle {
        text-align: center;
        color: #666;
        margin-bottom: 30px;
        font-size: 14px;
    }
    table {
        border-collapse: collapse;
        width: 100%;
        background-color: #fff;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    th, td {
        border: 1px solid #999;
        padding: 8px;
        text-align: center;
        font-size: 14px;
    }
    th {
        background-color: #e6e6e6;
        color: #000;
    }
    tr:nth-child(even) td {
        background-color: #f9f9f9;
    }
    tr:hover td {
        background-color: #ffffcc;
    }
    .total-row {
        background-color: #ccffcc;
        font-weight: bold;
    }
    .button-group {
        margin-top: 25px;
        text-align: center;
    }
    .button-group button {
        padding: 10px 25px;
        font-size: 16px;
        background-color: #4CAF50;
        color: white;
        border: none;
        border-radius: 6px;
        cursor: pointer;
        margin: 5px;
    }
    .button-group button:hover {
        background-color: #45a049;
    }
    /* Sembunyikan tombol saat dicetak */
    @media print {
        .button-group {
            display: none;
        }
        body {
            margin: 10px;
            background: white;
        }
        table {
            box-shadow: none;
        }
    }
</style>
</head>
<body>

<h1>Laporan Data Transaksi</h1>
<p class="subtitle">Toko Online Maju Jaya — <?= date('d F Y') ?></p>
<?php endif; ?>

<table border="1">
    <tr>
        <th>No. Transaksi</th>
        <th>Tanggal</th>
        <th>Nama Pelanggan</th>
        <th>Alamat</th>
        <th>Email</th>
        <th>No. Hape</th>
        <th>Nama Barang</th>
        <th>Harga Satuan</th>
        <th>Diskon (%)</th>
        <th>Jumlah Beli</th>
        <th>Total (Rp)</th>
    </tr>

    <?php
    $total_semua = 0;
    if (mysqli_num_rows($hasil) > 0) {
        while ($row = mysqli_fetch_assoc($hasil)) {
            $tanggal_format = formatTanggalIndo($row['Tanggal']);
            $harga_diskon = $row['Harga'] - ($row['Harga'] * ($row['Diskon'] / 100));
            $total = $row['Jumlah_beli'] * $harga_diskon;
            $total_semua += $total;

            echo "<tr>
                    <td>{$row['no_id']}</td>
                    <td>{$tanggal_format}</td>
                    <td>{$row['Nama']}</td>
                    <td>{$row['Alamat']}</td>
                    <td>{$row['Email']}</td>
                    <td>{$row['No_hape']}</td>
                    <td>{$row['Nama_barang']}</td>
                    <td>" . number_format($row['Harga'], 0, ',', '.') . "</td>
                    <td>{$row['Diskon']}</td>
                    <td>{$row['Jumlah_beli']}</td>
                    <td>" . number_format($total, 0, ',', '.') . "</td>
                  </tr>";
        }

        echo "<tr class='total-row'>
                <td colspan='10' align='right'>TOTAL SEMUA TRANSAKSI:</td>
                <td>" . number_format($total_semua, 0, ',', '.') . "</td>
              </tr>";
    } else {
        echo "<tr><td colspan='11'><b>Tidak ada data transaksi ditemukan.</b></td></tr>";
    }

    mysqli_close($koneksi);
    ?>
</table>

<?php if (!isset($_GET['export'])): ?>
<div class="button-group">
    <button onclick="window.print()">🖨️ Cetak Laporan</button>
    <button onclick="window.location.href='?export=excel'">📥 Export ke Excel</button>
</div>

</body>
</html>
<?php endif; ?>
