<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$message = "";

// --- Proses update email ---
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email_baru = trim($_POST['email'] ?? '');

    if ($email_baru === '') {
        $message = "<div class='msg error'>❌ Email tidak boleh kosong.</div>";
    } elseif (!filter_var($email_baru, FILTER_VALIDATE_EMAIL)) {
        $message = "<div class='msg error'>❌ Format email tidak valid.</div>";
    } else {
        $stmt = $conn->prepare("UPDATE bukti SET Email_bukti = ? WHERE 1");
        $stmt->bind_param("s", $email_baru);
        if ($stmt->execute()) {
            $message = "<div class='msg success'>✅ Email resmi perusahaan berhasil diperbarui.</div>";
        } else {
            $message = "<div class='msg error'>❌ Gagal memperbarui email.</div>";
        }
        $stmt->close();
    }
}

// --- Ambil email saat ini ---
$current_email = "";
$result = $conn->query("SELECT Email_bukti FROM bukti LIMIT 1");
if ($row = $result->fetch_assoc()) {
    $current_email = htmlspecialchars($row['Email_bukti']);
}
$conn->close();
?>

<html>
<head>
<title>Data Email Perusahaan</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background: linear-gradient(180deg, #f3f6fb, #d9e4f5);
    margin: 0;
    padding: 0;
}
.container {
    max-width: 600px;
    margin: 100px auto;
    background: white;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
    padding: 40px;
    text-align: center;
}
h1 {
    color: #2b4c7e;
    margin-bottom: 10px;
}
h3 {
    color: #5a5a5a;
    font-weight: normal;
}
input[type=email] {
    width: 80%;
    padding: 12px;
    border-radius: 6px;
    border: 1px solid #ccc;
    font-size: 16px;
    margin-top: 15px;
}
input[type=submit] {
    background-color: #2b4c7e;
    color: white;
    border: none;
    border-radius: 6px;
    padding: 12px 24px;
    font-size: 16px;
    cursor: pointer;
    margin-top: 25px;
    transition: 0.3s;
}
input[type=submit]:hover {
    background-color: #1a3355;
}
.msg {
    padding: 10px;
    margin-bottom: 20px;
    border-radius: 6px;
    font-size: 15px;
    text-align: center;
}
.msg.success {
    background-color: #e8f8ec;
    color: #208c41;
    border: 1px solid #b7e1be;
}
.msg.error {
    background-color: #ffeaea;
    color: #a80000;
    border: 1px solid #e0b0b0;
}
a.button {
    display: inline-block;
    margin-top: 30px;
    background: #4b74b2;
    color: white;
    padding: 10px 22px;
    border-radius: 6px;
    text-decoration: none;
    transition: 0.3s;
}
a.button:hover {
    background: #335d99;
}
footer {
    margin-top: 40px;
    color: #666;
    font-size: 13px;
}
</style>
</head>
<body>

<div class="container">
    <h1>📧 Data Email Perusahaan</h1>
    <h3>Digunakan untuk menerima bukti bayar (file gambar)</h3>
    <br>

    <?= $message ?>

    <form method="post">
        <input type="email" name="email" placeholder="Masukkan email resmi perusahaan" value="<?= $current_email ?>" required><br>
        <input type="submit" value="💾 Simpan Perubahan">
    </form>

    <a href="admin_dashboard.php" class="button">🏠 Kembali ke Dashboard</a>

    <footer>
        <br><br>© <?= date('Y') ?> Toko Online Maju Jaya
    </footer>
</div>

</body>
</html>
