<?php
session_start();

include 'db.php';

// 🔒 Hanya admin yang bisa mengakses
if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$message = "";

// 🧾 Proses form (update data)
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $nama_bank = trim($_POST['nama_bank'] ?? '');
    $no_rek = trim($_POST['no_rek'] ?? '');
    $nama = trim($_POST['nama'] ?? '');

    if ($nama_bank === '' || $no_rek === '' || $nama === '') {
        $message = "<p style='color:red;'>❌ Semua kolom wajib diisi.</p>";
    } else {
        // Jika tabel masih kosong, tambahkan baris awal agar UPDATE tidak gagal
        $cek = $conn->query("SELECT COUNT(*) AS jml FROM rekening");
        $row = $cek->fetch_assoc();
        if ($row['jml'] == 0) {
            $conn->query("INSERT INTO rekening (Nama_bank, No_rek, Atas_nama) VALUES ('', '', '')");
        }

        $stmt = $conn->prepare("UPDATE rekening SET Nama_bank = ?, No_rek = ?, Atas_nama = ? WHERE 1");
        $stmt->bind_param("sss", $nama_bank, $no_rek, $nama);

        if ($stmt->execute()) {
            $message = "<p style='color:green;'>✅ Data rekening berhasil diperbarui!</p>";
        } else {
            $message = "<p style='color:red;'>❌ Gagal memperbarui data rekening: " . htmlspecialchars($stmt->error) . "</p>";
        }

        $stmt->close();
    }
}

// 🔍 Ambil data rekening saat ini
$result = $conn->query("SELECT Nama_bank, No_rek, Atas_nama FROM rekening LIMIT 1");
$current = $result && $result->num_rows > 0
    ? $result->fetch_assoc()
    : ['Nama_bank' => '', 'No_rek' => '', 'Atas_nama' => ''];

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<title>Data Rekening Penjual</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background-color: #f4f6f7;
}
.container {
    width: 600px;
    margin: 80px auto;
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 0 15px rgba(0,0,0,0.2);
    padding: 30px;
    text-align: center;
}
h2 {
    color: #004c70;
}
label {
    font-weight: bold;
}
input[type=text] {
    width: 80%;
    padding: 8px;
    margin-top: 5px;
    font-size: 14px;
    border: 1px solid #ccc;
    border-radius: 5px;
}
input[type=submit], .back-btn {
    background: #007acc;
    color: white;
    padding: 10px 25px;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 15px;
    margin-top: 10px;
    text-decoration: none;
    display: inline-block;
}
input[type=submit]:hover, .back-btn:hover {
    background: #005f99;
}
.message {
    margin: 15px 0;
}
</style>
</head>

<body>
<div class="container">
    <h2>💳 Data Rekening Penjual</h2>
    <div class="message"><?= $message ?></div>

    <form method="post">
        <label>Nama Bank:</label><br>
        <input type="text" name="nama_bank" value="<?= htmlspecialchars($current['Nama_bank']) ?>"><br><br>

        <label>No. Rekening:</label><br>
        <input type="text" name="no_rek" value="<?= htmlspecialchars($current['No_rek']) ?>"><br><br>

        <label>Nama Pemilik Rekening:</label><br>
        <input type="text" name="nama" value="<?= htmlspecialchars($current['Atas_nama']) ?>"><br><br>

        <input type="submit" value="💾 Simpan Perubahan">
    </form>

    <br>
    <!-- 🔙 Tombol kembali ke dashboard -->
    <a href="admin_dashboard.php" class="back-btn">⬅️ Kembali ke Dashboard</a>
</div>
</body>
</html>
