<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$email = "admin@admin.com";

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$message = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $sandi  = trim($_POST['sandi'] ?? '');
    $sandi2 = trim($_POST['konfirmasi'] ?? '');

    if ($sandi === '' || $sandi2 === '') {
        $message = "<p style='color:red;'>⚠️ Kedua kolom sandi wajib diisi.</p>";
    } elseif ($sandi !== $sandi2) {
        $message = "<p style='color:red;'>❌ Sandi tidak sama. Ulangi lagi.</p>";
    } else {
        $acak = password_hash($sandi, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password = ? WHERE username = ?");
        $stmt->bind_param("ss", $acak, $email);

        if ($stmt->execute()) {
            $message = "<p style='color:green;'>✅ Sandi admin berhasil diubah!</p>";
        } else {
            $message = "<p style='color:red;'>❌ Gagal menyimpan sandi: " . htmlspecialchars($stmt->error) . "</p>";
        }

        $stmt->close();
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Ubah Sandi Admin</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background: linear-gradient(135deg, #e0e0e0, #cfd9df);
    height: 100vh;
    margin: 0;
    display: flex;
    align-items: center;
    justify-content: center;
}
.container {
    background: white;
    padding: 40px 50px;
    border-radius: 12px;
    box-shadow: 0 0 15px rgba(0,0,0,0.2);
    text-align: center;
}
h1 {
    font-size: 26px;
    margin-bottom: 20px;
    color: #333;
}
input[type=password] {
    width: 250px;
    padding: 10px;
    font-size: 16px;
    border: 1px solid #ccc;
    border-radius: 8px;
    margin-top: 8px;
}
button {
    margin-top: 20px;
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 25px;
    font-size: 16px;
    border-radius: 8px;
    cursor: pointer;
}
button:hover {
    background-color: #0056b3;
}
.message {
    margin-top: 15px;
}
</style>
</head>

<body>
<div class="container">
    <h1>🔐 Ubah Sandi Admin</h1>

    <?php if (!empty($message)) echo "<div class='message'>$message</div>"; ?>

    <form method="post">
        <div>
            <label>Password Baru</label><br>
            <input type="password" name="sandi" required>
        </div>
        <div style="margin-top:15px;">
            <label>Konfirmasi Password</label><br>
            <input type="password" name="konfirmasi" required>
        </div>
        <button type="submit">Simpan</button>
    </form>
</div>
</body>
</html>
