<?php

// tidak ada file: fpdf.php, adanya index.htm (pada filder fpdf/)

require('fpdf/fpdf.php'); // pastikan folder fpdf sudah ada
include 'db.php';
session_start();

// 🔒 Hanya pelanggan yang login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$email = trim($_SESSION['username']);
$invoice = trim($_GET['inv'] ?? '');

if ($invoice === '') {
    die("Invoice tidak ditemukan.");
}

// 🔌 Koneksi
$conn = new mysqli($servername, $username, $password, $database);
$conn->set_charset("utf8mb4");

// Ambil data pelanggan
$stmt = $conn->prepare("SELECT no_id, Nama, Alamat, Email FROM pelanggan WHERE Email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($no_plg, $nama, $alamat, $email_plg);
if (!$stmt->fetch()) die("Pelanggan tidak ditemukan.");
$stmt->close();

// Ambil data transaksi
$stmt = $conn->prepare("
    SELECT b.Nama_barang, b.Harga, COALESCE(b.Diskon,0) AS Diskon,
           t.Jumlah_beli,
           (b.Harga * (1 - COALESCE(b.Diskon,0)/100.0)) AS HargaDiskon
    FROM transaksi t
    JOIN barang b ON t.no_brg = b.no_id
    WHERE t.no_plg = ? AND t.Invoice = ?
");
$stmt->bind_param("is", $no_plg, $invoice);
$stmt->execute();
$result = $stmt->get_result();

$items = [];
$total = 0;
while ($r = $result->fetch_assoc()) {
    $hargaDiskon = (float)$r['HargaDiskon'];
    $subtotal = $hargaDiskon * (float)$r['Jumlah_beli'];
    $r['Subtotal'] = $subtotal;
    $items[] = $r;
    $total += $subtotal;
}
$stmt->close();

// Ambil ongkos kirim
$ongkos = 0;
$res = $conn->query("SELECT Ongkos FROM kirim LIMIT 1");
if ($row = $res->fetch_assoc()) $ongkos = (float)$row['Ongkos'];
$res->free();
$conn->close();

$grand = $total + $ongkos;

// ==================================================
// 🔧 CETAK PDF
// ==================================================
$pdf = new FPDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial','B',16);
$pdf->Cell(0,10,'INVOICE PEMBELIAN',0,1,'C');
$pdf->Ln(5);

// Info pelanggan
$pdf->SetFont('Arial','',12);
$pdf->Cell(40,7,'Nomor Invoice',0,0);
$pdf->Cell(80,7,": $invoice",0,1);
$pdf->Cell(40,7,'Nama Pelanggan',0,0);
$pdf->Cell(80,7,": $nama",0,1);
$pdf->Cell(40,7,'Alamat',0,0);
$pdf->MultiCell(120,7,": $alamat",0,1);
$pdf->Ln(3);

// Tabel
$pdf->SetFont('Arial','B',11);
$pdf->Cell(70,8,'Nama Barang',1,0,'C');
$pdf->Cell(30,8,'Harga',1,0,'C');
$pdf->Cell(25,8,'Diskon (%)',1,0,'C');
$pdf->Cell(25,8,'Jumlah',1,0,'C');
$pdf->Cell(40,8,'Subtotal',1,1,'C');

$pdf->SetFont('Arial','',10);
foreach ($items as $it) {
    $pdf->Cell(70,8,$it['Nama_barang'],1,0);
    $pdf->Cell(30,8,"Rp ".number_format($it['Harga'],0,',','.'),1,0,'R');
    $pdf->Cell(25,8,$it['Diskon'],1,0,'C');
    $pdf->Cell(25,8,$it['Jumlah_beli'],1,0,'C');
    $pdf->Cell(40,8,"Rp ".number_format($it['Subtotal'],0,',','.'),1,1,'R');
}

$pdf->SetFont('Arial','B',11);
$pdf->Cell(150,8,'Subtotal',1,0,'R');
$pdf->Cell(40,8,"Rp ".number_format($total,0,',','.'),1,1,'R');

$pdf->Cell(150,8,'Ongkos Kirim',1,0,'R');
$pdf->Cell(40,8,"Rp ".number_format($ongkos,0,',','.'),1,1,'R');

$pdf->Cell(150,8,'Total Bayar',1,0,'R');
$pdf->Cell(40,8,"Rp ".number_format($grand,0,',','.'),1,1,'R');

$pdf->Ln(10);
$pdf->SetFont('Arial','I',10);
$pdf->Cell(0,8,'Terima kasih telah berbelanja.',0,1,'C');

$pdf->Output('I', "Invoice-$invoice.pdf");
?>
